/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.struts;

import cn.coder.struts.StrutsFilter;
import cn.coder.struts.annotation.AutoRun;
import cn.coder.struts.annotation.Request;
import cn.coder.struts.support.ActionIntercepter;
import cn.coder.struts.support.WebInitializer;
import cn.coder.struts.util.ClassUtils;
import cn.coder.struts.wrapper.ActionWrapper;
import cn.coder.struts.wrapper.SessionWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={WebInitializer.class})
public class StrutsContainerInitializer
implements ServletContainerInitializer,
ClassUtils.FilterClassType {
    private static final Logger logger = LoggerFactory.getLogger(StrutsContainerInitializer.class);
    private final ActionWrapper actionWrapper = new ActionWrapper();
    private final HashMap<Class<?>, Object> classes = new HashMap();
    private final ArrayList<ActionIntercepter> filters = new ArrayList();

    public void onStartup(Set<Class<?>> initializerClasses, ServletContext ctx) throws ServletException {
        long start = System.nanoTime();
        ClassUtils.scanClasses(ctx, "/", this);
        ctx.setAttribute("ActionWrapper", (Object)this.actionWrapper);
        ctx.setAttribute("Classes", this.classes);
        ctx.setAttribute("Filters", this.filters);
        ctx.setAttribute("InitializerClasses", initializerClasses);
        ctx.addListener(SessionWrapper.class);
        ctx.addFilter("StrutsFilter", StrutsFilter.class);
        if (logger.isDebugEnabled()) {
            logger.debug("ServletContext start up:{}ns", (Object)(System.nanoTime() - start));
        }
    }

    @Override
    public void filter(Class<?> clazz) {
        if (clazz != null) {
            if (ClassUtils.isController(clazz)) {
                this.bindActions(clazz);
            } else if (ClassUtils.isFilter(clazz)) {
                this.bindFilter(clazz);
            }
            this.classes.put(clazz, null);
        }
    }

    private void bindFilter(Class<?> clazz) {
        try {
            this.filters.add((ActionIntercepter)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Instance intercepter faild", (Throwable)e);
        }
    }

    private void bindActions(Class<?> clazz) {
        Method[] methods;
        Request classReq = clazz.getAnnotation(Request.class);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Request methodReq = method.getAnnotation(Request.class);
            if (methodReq != null) {
                this.actionWrapper.put(ClassUtils.getUrlMapping(classReq, methodReq.value()), method);
            }
            if (method.getAnnotation(AutoRun.class) == null) continue;
            this.actionWrapper.add(method);
        }
    }
}

