/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.easywx.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    static final Logger logger = LoggerFactory.getLogger(XMLUtils.class);

    public static String deserialize(BufferedReader reader) {
        try {
            String line;
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String xml = buffer.toString();
            logger.debug("[XML]" + xml);
            return xml;
        }
        catch (IOException e) {
            logger.error("Deserialize xml faild", (Throwable)e);
            return null;
        }
    }

    public static HashMap<String, Object> doXMLParse(String xml) {
        if (xml == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        DocumentBuilderFactory factory = null;
        try {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("utf-8"));
                factory = DocumentBuilderFactory.newInstance();
                factory.setExpandEntityReferences(false);
                Document doc = factory.newDocumentBuilder().parse(in);
                ((InputStream)in).close();
                XMLUtils.getMapByNode(doc.getDocumentElement(), m);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error("Parse xml faild", (Throwable)e);
                factory = null;
            }
        }
        finally {
            factory = null;
        }
        return m;
    }

    private static void getMapByNode(Node node, HashMap<String, Object> m) {
        NodeList nodeList = node.getChildNodes();
        int nodeNum = nodeList.getLength();
        if (nodeNum > 0) {
            int i = 0;
            while (i < nodeNum) {
                Node node2 = nodeList.item(i);
                if (node2 instanceof Element) {
                    String k = node2.getNodeName();
                    String v = node2.getTextContent();
                    m.put(k, v);
                    XMLUtils.getMapByNode(node2, m);
                }
                ++i;
            }
        }
    }

    public static String toXML(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        for (String key : map.keySet()) {
            Object val = map.get(key);
            if (val == null) continue;
            if (val.toString().contains("![CDATA[")) {
                sb.append("<");
                sb.append((Object)key);
                sb.append(">");
                sb.append(val);
                sb.append("</");
                sb.append((Object)key);
                sb.append(">");
                continue;
            }
            sb.append("<");
            sb.append((Object)key);
            sb.append("><![CDATA[");
            sb.append(val);
            sb.append("]]></");
            sb.append((Object)key);
            sb.append(">");
        }
        sb.append("</xml>");
        String xml = sb.toString();
        logger.debug("[XML]" + xml);
        return sb.toString();
    }
}

