/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.easywx.core;

import cn.coder.easywx.core.Base;
import cn.coder.easywx.result.PayResult;
import cn.coder.easywx.result.RefundOrder;
import cn.coder.easywx.result.UnifiedOrder;
import cn.coder.easywx.util.SignUtils;
import cn.coder.easywx.util.XMLUtils;
import java.io.BufferedReader;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Payment
extends Base {
    private static final Logger logger = LoggerFactory.getLogger(Payment.class);
    private static final String URL_CREATE_UNIFIEDORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String URL_REFUNDORDER = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private final String apiKey;
    private final String mchId;
    private final String notifyUrl;
    private final String appId;

    public Payment(String appId, String mchId, String apiKey, String callbackUrl) {
        this.appId = appId;
        this.mchId = mchId;
        this.apiKey = apiKey;
        this.notifyUrl = callbackUrl;
    }

    public PayResult callback(BufferedReader reader) {
        String xml = XMLUtils.deserialize(reader);
        logger.debug("[Wechat]:" + xml);
        HashMap<String, Object> result = XMLUtils.doXMLParse(xml);
        if (result.containsKey("req_info")) {
            HashMap<String, Object> result2;
            byte[] data = Base64.getDecoder().decode(result.get("req_info").toString());
            byte[] key = SignUtils.encodeByMD5(this.apiKey).toLowerCase().getBytes();
            Security.addProvider((Provider)new BouncyCastleProvider());
            String str = SignUtils.decryptData(data, key);
            logger.debug("[Wechat]" + str);
            if (str != null && "SUCCESS".equals(Payment.getValue(result2 = XMLUtils.doXMLParse(str), "refund_status"))) {
                PayResult msg = new PayResult(true);
                msg.mch_id = Payment.getValue(result, "mch_id");
                msg.appid = Payment.getValue(result, "appid");
                msg.out_trade_no = Payment.getValue(result2, "out_trade_no");
                msg.out_refund_no = Payment.getValue(result2, "out_refund_no");
                msg.success_time = Payment.getValue(result2, "success_time");
                msg.refund_fee = Payment.getValue(result2, "refund_fee");
                return msg;
            }
            return null;
        }
        String returnCode = Payment.getValue(result, "return_code");
        String resultCode = Payment.getValue(result, "result_code");
        if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
            String sign = result.remove("sign").toString();
            if (SignUtils.getSign(result, this.apiKey).equals(sign)) {
                PayResult msg = new PayResult(false);
                msg.appid = Payment.getValue(result, "appid");
                msg.mch_id = Payment.getValue(result, "mch_id");
                msg.openid = Payment.getValue(result, "openid");
                msg.trade_type = Payment.getValue(result, "trade_type");
                msg.out_trade_no = Payment.getValue(result, "out_trade_no");
                msg.time_end = Payment.getValue(result, "time_end");
                msg.cash_fee = Payment.getValue(result, "cash_fee");
                return msg;
            }
            logger.debug("Check sign faild");
        }
        return null;
    }

    public Map<String, Object> createUnifiedOrder(UnifiedOrder order) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appid", this.appId);
        map.put("mch_id", this.mchId);
        map.put("nonce_str", Payment.getRandamStr());
        if (order.body.length() > 64) {
            map.put("body", order.body.substring(0, 64));
        } else {
            map.put("body", order.body);
        }
        map.put("out_trade_no", order.out_trade_no);
        map.put("total_fee", order.total_fee);
        map.put("spbill_create_ip", order.spbill_create_ip);
        map.put("notify_url", this.notifyUrl);
        if (order.sub_mch_id != null) {
            map.put("sub_mch_id", order.sub_mch_id);
        }
        if (order.trade_type != null) {
            map.put("trade_type", order.trade_type);
        } else if (order.openid == null) {
            map.put("trade_type", "APP");
        } else {
            map.put("trade_type", "JSAPI");
            map.put("openid", order.openid);
        }
        map.put("sign", SignUtils.getSign(map, this.apiKey));
        String return_xml = Payment.postString(URL_CREATE_UNIFIEDORDER, XMLUtils.toXML(map));
        logger.debug("[UnifiedOrder]" + return_xml);
        HashMap<String, Object> result = XMLUtils.doXMLParse(return_xml);
        String returnCode = Payment.getValue(result, "return_code");
        String resultCode = Payment.getValue(result, "result_code");
        if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
            HashMap<String, Object> maplast = new HashMap<String, Object>();
            String tradeType = Payment.getValue(result, "trade_type");
            String prepayid = Payment.getValue(result, "prepay_id");
            if ("NATIVE".equals(tradeType)) {
                maplast.put("appid", this.appId);
                maplast.put("partnerid", this.mchId);
                maplast.put("prepayid", prepayid);
                maplast.put("code_url", Payment.getValue(result, "code_url"));
                return maplast;
            }
            if (order.openid == null) {
                maplast.put("appid", this.appId);
                maplast.put("noncestr", Payment.getRandamStr());
                maplast.put("partnerid", this.mchId);
                maplast.put("prepayid", prepayid);
                maplast.put("timestamp", Payment.getTimestamp());
                maplast.put("package", "Sign=WXPay");
                maplast.put("sign", SignUtils.getSign(maplast, this.apiKey));
            } else {
                maplast.put("appId", this.appId);
                maplast.put("nonceStr", Payment.getRandamStr());
                maplast.put("package", "prepay_id=" + prepayid);
                maplast.put("timeStamp", Payment.getTimestamp());
                maplast.put("signType", "MD5");
                maplast.put("paySign", SignUtils.getSign(maplast, this.apiKey));
            }
            return maplast;
        }
        return null;
    }

    public boolean refundCash(RefundOrder order, SSLSocketFactory ssl) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appid", this.appId);
            map.put("mch_id", this.mchId);
            map.put("nonce_str", Payment.getRandamStr());
            map.put("out_trade_no", order.out_trade_no);
            map.put("out_refund_no", order.out_refund_no);
            map.put("total_fee", order.total_fee);
            map.put("refund_fee", order.refund_fee);
            map.put("notify_url", this.notifyUrl);
            map.put("sign", SignUtils.getSign(map, this.apiKey));
            String return_xml = Payment.postString(URL_REFUNDORDER, ssl, XMLUtils.toXML(map));
            logger.debug("[XML]" + return_xml);
            HashMap<String, Object> result = XMLUtils.doXMLParse(return_xml);
            String returnCode = Payment.getValue(result, "return_code");
            String resultCode = Payment.getValue(result, "result_code");
            return "SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode);
        }
        catch (Exception e) {
            logger.error("Refund cash faild", (Throwable)e);
            return false;
        }
    }
}

