/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.easywx.core;

import cn.coder.easywx.core.Base;
import cn.coder.easywx.core.Payment;
import cn.coder.easywx.result.SignedURL;
import cn.coder.easywx.util.JSONUtils;
import cn.coder.easywx.util.SignUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP
extends Base {
    private static final Logger logger = LoggerFactory.getLogger(MP.class);
    private static final long TIME = 7100000L;
    private static final String URL_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String URL_JSTICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String URL_OPENID = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private final String appId;
    private final String appSecret;
    private Payment _pay;
    private String _token;
    private long _tokenTime;
    private String _jsticket;
    private long _tokenTime2;

    public MP(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public synchronized String getAccessToken() {
        if (this._token == null || System.currentTimeMillis() - this._tokenTime > 7100000L) {
            String json = MP.getJSON(String.format(URL_TOKEN, this.appId, this.appSecret));
            logger.debug("[ACCESS_TOKEN]" + json);
            if (MP.valid(json, "access_token")) {
                this._token = JSONUtils.getString(json, "access_token");
                this._tokenTime = System.currentTimeMillis();
            }
        }
        return this._token;
    }

    public void forPayment(String mchId, String apiKey, String callbackUrl) {
        this._pay = new Payment(this.appId, mchId, apiKey, callbackUrl);
    }

    public Payment pay() {
        if (this._pay == null) {
            throw new NullPointerException("The payment can not be null");
        }
        return this._pay;
    }

    public String getOpenId(String code) {
        String json = MP.getJSON(String.format(URL_OPENID, this.appId, this.appSecret, code));
        logger.debug("[OPENID]" + json);
        if (MP.valid(json, "openid")) {
            return JSONUtils.getString(json, "openid");
        }
        return null;
    }

    public synchronized String getJsapiTicket() {
        if (this._jsticket == null || System.currentTimeMillis() - this._tokenTime2 > 7100000L) {
            String json = MP.getJSON(String.format(URL_JSTICKET, this.getAccessToken()));
            logger.debug("[JSAPI_TICKET]" + json);
            if (MP.valid(json, "ticket")) {
                this._jsticket = JSONUtils.getString(json, "ticket");
                this._tokenTime2 = System.currentTimeMillis();
            }
        }
        return this._jsticket;
    }

    public SignedURL signRequestURL(String url) {
        try {
            String nonceStr = MP.getRandamStr();
            long time = MP.getTimestamp();
            String jsapiTicket = this.getJsapiTicket();
            StringBuilder signStr = new StringBuilder();
            signStr.append("jsapi_ticket=").append(jsapiTicket);
            signStr.append("&noncestr=").append(nonceStr);
            signStr.append("&timestamp=").append(time);
            signStr.append("&url=").append(url);
            if (logger.isDebugEnabled()) {
                logger.debug("Sign str:{}", (Object)signStr);
            }
            SignedURL ticket = new SignedURL();
            ticket.url = url;
            ticket.appId = this.appId;
            ticket.nonceStr = nonceStr;
            ticket.timestamp = time;
            ticket.signature = SignUtils.SHA1(signStr.toString());
            ticket.jsapiTicket = jsapiTicket;
            return ticket;
        }
        catch (RuntimeException e) {
            logger.error("signRequestURL faild", (Throwable)e);
            return null;
        }
    }

    public static interface MsgEvent {
        public BufferedReader getReader() throws IOException;

        public void doView(Map<String, Object> var1);

        public void doUnSubscribe(Map<String, Object> var1);

        public void doText(Map<String, Object> var1);

        public void doSubscribe(String var1, Map<String, Object> var2);

        public void doScan(String var1, Map<String, Object> var2);

        public void doResponse(String var1);
    }
}

