/*
 * Decompiled with CFR 0.152.
 */
package cn.coder.easywx.core;

import cn.coder.easywx.util.JSONUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base {
    private static final Logger logger = LoggerFactory.getLogger(Base.class);

    protected static String getRandamStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    protected static long getTimestamp() {
        return new Date().getTime() / 1000L;
    }

    protected static String getValue(Map<String, Object> result, String key) {
        if (result == null || key == null) {
            return null;
        }
        if (result.containsKey(key)) {
            return result.get(key).toString();
        }
        return null;
    }

    protected static boolean valid(String json, String key) {
        if (json == null || "".equals(json)) {
            return false;
        }
        return json.contains("\"" + key + "\"");
    }

    protected static String getJSON(String url) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONUtils.readStream(sb, new URL(url).openStream());
        }
        catch (IOException e) {
            logger.error("[GET]" + url + " faild", (Throwable)e);
        }
        return sb.toString();
    }

    protected static String postString(String url, String paras) {
        return Base.postString(url, null, paras);
    }

    protected static String postString(String url, SSLSocketFactory ssl, String paras) {
        StringBuilder sb = new StringBuilder();
        try {
            URLConnection connection = new URL(url).openConnection();
            if (ssl != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssl);
                if (logger.isDebugEnabled()) {
                    logger.debug("URL connection with ssl");
                }
            }
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(paras.getBytes("utf-8"));
            outputStream.flush();
            outputStream.close();
            JSONUtils.readStream(sb, connection.getInputStream());
        }
        catch (IOException e) {
            logger.error("[POST]" + url + " faild,", (Throwable)e);
        }
        return sb.toString();
    }
}

