/*
 * Decompiled with CFR 0.152.
 */
package cloud.toolshed.jsup;

import cloud.toolshed.jsup.UserPreferencesAnalytics;
import cloud.toolshed.jsup.UserPreferencesAnalyticsImpl;
import cloud.toolshed.jsup.UserPreferencesDb;
import cloud.toolshed.jsup.UserPreferencesDbImpl;
import cloud.toolshed.jsup.jooq.generated.Tables;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Provides;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class UserPreferencesModule
extends AbstractModule {
    protected void configure() {
        this.requireBinding(Key.get(DataSource.class, UserPreferences.class));
        this.requireBinding(Key.get(SQLDialect.class, UserPreferences.class));
        this.bind(UserPreferencesDb.class).to(UserPreferencesDbImpl.class);
        this.bind(UserPreferencesAnalytics.class).to(UserPreferencesAnalyticsImpl.class);
    }

    @Inject
    @Provides
    @Singleton
    @UserPreferencesInternal
    DataSource provideDataSource(@UserPreferences DataSource dataSource, @UserPreferences SQLDialect sqlDialect) {
        DSLContext dslContext = DSL.using((DataSource)dataSource, (SQLDialect)sqlDialect);
        try {
            this.createSchemaIfNotExists(dslContext, sqlDialect);
            dslContext.createTableIfNotExists((Table)Tables.BOOLEAN_PREFERENCES).column(Tables.BOOLEAN_PREFERENCES.USERNAME, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.BOOLEAN_PREFERENCES.CATEGORY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.BOOLEAN_PREFERENCES.KEY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.BOOLEAN_PREFERENCES.VALUE, SQLDataType.TINYINT.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + Tables.BOOLEAN_PREFERENCES.getName())).primaryKey(new Field[]{Tables.BOOLEAN_PREFERENCES.USERNAME, Tables.BOOLEAN_PREFERENCES.CATEGORY, Tables.BOOLEAN_PREFERENCES.KEY})}).execute();
            dslContext.createIndex("I_" + Tables.BOOLEAN_PREFERENCES.getName()).on((Table)Tables.BOOLEAN_PREFERENCES, new Field[]{Tables.BOOLEAN_PREFERENCES.CATEGORY, Tables.BOOLEAN_PREFERENCES.KEY, Tables.BOOLEAN_PREFERENCES.VALUE});
            dslContext.createTableIfNotExists((Table)Tables.INTEGER_PREFERENCES).column(Tables.INTEGER_PREFERENCES.USERNAME, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.INTEGER_PREFERENCES.CATEGORY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.INTEGER_PREFERENCES.KEY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.INTEGER_PREFERENCES.VALUE, SQLDataType.INTEGER.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + Tables.INTEGER_PREFERENCES.getName())).primaryKey(new Field[]{Tables.INTEGER_PREFERENCES.USERNAME, Tables.INTEGER_PREFERENCES.CATEGORY, Tables.INTEGER_PREFERENCES.KEY})}).execute();
            dslContext.createIndex("I_" + Tables.INTEGER_PREFERENCES.getName()).on((Table)Tables.INTEGER_PREFERENCES, new Field[]{Tables.INTEGER_PREFERENCES.CATEGORY, Tables.INTEGER_PREFERENCES.KEY, Tables.INTEGER_PREFERENCES.VALUE});
            dslContext.createTableIfNotExists((Table)Tables.FLOAT_PREFERENCES).column(Tables.FLOAT_PREFERENCES.USERNAME, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.FLOAT_PREFERENCES.CATEGORY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.FLOAT_PREFERENCES.KEY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.FLOAT_PREFERENCES.VALUE, SQLDataType.FLOAT.nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + Tables.FLOAT_PREFERENCES.getName())).primaryKey(new Field[]{Tables.FLOAT_PREFERENCES.USERNAME, Tables.FLOAT_PREFERENCES.CATEGORY, Tables.FLOAT_PREFERENCES.KEY})}).execute();
            dslContext.createIndex("I_" + Tables.FLOAT_PREFERENCES.getName()).on((Table)Tables.FLOAT_PREFERENCES, new Field[]{Tables.FLOAT_PREFERENCES.CATEGORY, Tables.FLOAT_PREFERENCES.KEY, Tables.FLOAT_PREFERENCES.VALUE});
            dslContext.createTableIfNotExists((Table)Tables.STRING_PREFERENCES).column(Tables.STRING_PREFERENCES.USERNAME, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.STRING_PREFERENCES.CATEGORY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.STRING_PREFERENCES.KEY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.STRING_PREFERENCES.VALUE, SQLDataType.VARCHAR.length(512).nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + Tables.STRING_PREFERENCES.getName())).primaryKey(new Field[]{Tables.STRING_PREFERENCES.USERNAME, Tables.STRING_PREFERENCES.CATEGORY, Tables.STRING_PREFERENCES.KEY})}).execute();
            dslContext.createIndex("I_" + Tables.STRING_PREFERENCES.getName()).on((Table)Tables.STRING_PREFERENCES, new Field[]{Tables.STRING_PREFERENCES.CATEGORY, Tables.STRING_PREFERENCES.KEY, Tables.STRING_PREFERENCES.VALUE});
            dslContext.createTableIfNotExists((Table)Tables.SET_PREFERENCES).column(Tables.SET_PREFERENCES.USERNAME, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.SET_PREFERENCES.CATEGORY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.SET_PREFERENCES.KEY, SQLDataType.VARCHAR.length(512).nullable(false)).column(Tables.SET_PREFERENCES.VALUE, SQLDataType.VARCHAR.length(512).nullable(false)).constraints(new Constraint[]{DSL.constraint((String)("PK_" + Tables.SET_PREFERENCES.getName())).primaryKey(new Field[]{Tables.SET_PREFERENCES.USERNAME, Tables.SET_PREFERENCES.CATEGORY, Tables.SET_PREFERENCES.KEY, Tables.SET_PREFERENCES.VALUE})}).execute();
            dslContext.createIndex("I_" + Tables.SET_PREFERENCES.getName()).on((Table)Tables.SET_PREFERENCES, new Field[]{Tables.SET_PREFERENCES.CATEGORY, Tables.SET_PREFERENCES.KEY, Tables.SET_PREFERENCES.VALUE});
        }
        catch (DataAccessException dae) {
            throw new RuntimeException("Unable to create tables", dae);
        }
        return dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSchemaIfNotExists(DSLContext dslContext, SQLDialect sqlDialect) {
        String schemaName = "jsup";
        if (sqlDialect.equals((Object)SQLDialect.H2) || sqlDialect.equals((Object)SQLDialect.HSQLDB)) {
            schemaName = "\"jsup\"";
        }
        if (sqlDialect.equals((Object)SQLDialect.HSQLDB)) {
            try {
                dslContext.execute("create schema " + schemaName);
                return;
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("already exists")) return;
                throw ex;
            }
        } else {
            dslContext.execute("create schema if not exists " + schemaName);
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface UserPreferencesInternal {
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UserPreferences {
    }
}

