/*
 * Decompiled with CFR 0.152.
 */
package cloud.toolshed.jsup;

import cloud.toolshed.jsup.UserPreferencesDb;
import cloud.toolshed.jsup.UserPreferencesModule;
import cloud.toolshed.jsup.jooq.generated.Tables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;

@Singleton
class UserPreferencesDbImpl
implements UserPreferencesDb {
    private final DataSource dataSource;
    private final SQLDialect sqlDialect;

    @Inject
    UserPreferencesDbImpl(@UserPreferencesModule.UserPreferencesInternal DataSource dataSource, @UserPreferencesModule.UserPreferences SQLDialect sqlDialect) {
        this.dataSource = dataSource;
        this.sqlDialect = sqlDialect;
    }

    @Override
    @Nullable
    public Boolean getBoolean(String username, String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(new SelectField[0]).from((TableLike)Tables.BOOLEAN_PREFERENCES).where(new Condition[]{Tables.BOOLEAN_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.BOOLEAN_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.BOOLEAN_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return null;
            }
            return (Byte)((Record)result.get(0)).get(Tables.BOOLEAN_PREFERENCES.VALUE) != 0;
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch from %s %s/%s/%s", Tables.BOOLEAN_PREFERENCES.getName(), username, category, preferenceName), dae);
        }
    }

    @Override
    public void setBoolean(String username, String category, String preferenceName, @Nullable Boolean value) throws IOException {
        try {
            if (value == null) {
                this.createDslContext().delete((Table)Tables.BOOLEAN_PREFERENCES).where(new Condition[]{Tables.BOOLEAN_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.BOOLEAN_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.BOOLEAN_PREFERENCES.KEY.eq((Object)preferenceName)).execute();
            } else {
                byte byteValue = value == false ? (byte)0 : 1;
                this.createDslContext().mergeInto((Table)Tables.BOOLEAN_PREFERENCES, DSL.field(Tables.BOOLEAN_PREFERENCES.USERNAME), DSL.field(Tables.BOOLEAN_PREFERENCES.CATEGORY), DSL.field(Tables.BOOLEAN_PREFERENCES.KEY), DSL.field(Tables.BOOLEAN_PREFERENCES.VALUE)).key(new Field[]{DSL.field(Tables.BOOLEAN_PREFERENCES.USERNAME), DSL.field(Tables.BOOLEAN_PREFERENCES.CATEGORY), DSL.field(Tables.BOOLEAN_PREFERENCES.KEY)}).values((Object)username, (Object)category, (Object)preferenceName, (Object)byteValue).execute();
            }
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to save into %s %s/%s/%s: %s", Tables.BOOLEAN_PREFERENCES.getName(), username, category, preferenceName, value), dae);
        }
    }

    @Override
    @Nullable
    public Integer getInteger(String username, String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(new SelectField[0]).from((TableLike)Tables.INTEGER_PREFERENCES).where(new Condition[]{Tables.INTEGER_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.INTEGER_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.INTEGER_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return null;
            }
            return (Integer)((Record)result.get(0)).get(Tables.INTEGER_PREFERENCES.VALUE);
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch from %s %s/%s/%s", Tables.INTEGER_PREFERENCES.getName(), username, category, preferenceName), dae);
        }
    }

    @Override
    public void setInteger(String username, String category, String preferenceName, @Nullable Integer value) throws IOException {
        try {
            if (value == null) {
                this.createDslContext().delete((Table)Tables.INTEGER_PREFERENCES).where(new Condition[]{Tables.INTEGER_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.INTEGER_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.INTEGER_PREFERENCES.KEY.eq((Object)preferenceName)).execute();
            } else {
                this.createDslContext().mergeInto((Table)Tables.INTEGER_PREFERENCES, DSL.field(Tables.INTEGER_PREFERENCES.USERNAME), DSL.field(Tables.INTEGER_PREFERENCES.CATEGORY), DSL.field(Tables.INTEGER_PREFERENCES.KEY), DSL.field(Tables.INTEGER_PREFERENCES.VALUE)).key(new Field[]{DSL.field(Tables.INTEGER_PREFERENCES.USERNAME), DSL.field(Tables.INTEGER_PREFERENCES.CATEGORY), DSL.field(Tables.INTEGER_PREFERENCES.KEY)}).values((Object)username, (Object)category, (Object)preferenceName, (Object)value).execute();
            }
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to save into %s %s/%s/%s: %s", Tables.INTEGER_PREFERENCES.getName(), username, category, preferenceName, value), dae);
        }
    }

    @Override
    @Nullable
    public Float getFloat(String username, String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(new SelectField[0]).from((TableLike)Tables.FLOAT_PREFERENCES).where(new Condition[]{Tables.FLOAT_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.FLOAT_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.FLOAT_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return null;
            }
            return Float.valueOf((float)((Double)((Record)result.get(0)).get(Tables.FLOAT_PREFERENCES.VALUE)).doubleValue());
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch from %s %s/%s/%s", Tables.FLOAT_PREFERENCES.getName(), username, category, preferenceName), dae);
        }
    }

    @Override
    public void setFloat(String username, String category, String preferenceName, @Nullable Float value) throws IOException {
        try {
            if (value == null) {
                this.createDslContext().delete((Table)Tables.FLOAT_PREFERENCES).where(new Condition[]{Tables.FLOAT_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.FLOAT_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.FLOAT_PREFERENCES.KEY.eq((Object)preferenceName)).execute();
            } else {
                this.createDslContext().mergeInto((Table)Tables.FLOAT_PREFERENCES, DSL.field(Tables.FLOAT_PREFERENCES.USERNAME), DSL.field(Tables.FLOAT_PREFERENCES.CATEGORY), DSL.field(Tables.FLOAT_PREFERENCES.KEY), DSL.field(Tables.FLOAT_PREFERENCES.VALUE)).key(new Field[]{DSL.field(Tables.FLOAT_PREFERENCES.USERNAME), DSL.field(Tables.FLOAT_PREFERENCES.CATEGORY), DSL.field(Tables.FLOAT_PREFERENCES.KEY)}).values((Object)username, (Object)category, (Object)preferenceName, (Object)value.floatValue()).execute();
            }
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to save into %s %s/%s/%s: %s", Tables.FLOAT_PREFERENCES.getName(), username, category, preferenceName, value), dae);
        }
    }

    @Override
    @Nullable
    public String getString(String username, String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(new SelectField[0]).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return null;
            }
            return (String)((Record)result.get(0)).get(Tables.STRING_PREFERENCES.VALUE);
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch from %s %s/%s/%s", Tables.STRING_PREFERENCES.getName(), username, category, preferenceName), dae);
        }
    }

    @Override
    public void setString(String username, String category, String preferenceName, @Nullable String value) throws IOException {
        try {
            if (value == null) {
                this.createDslContext().delete((Table)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).execute();
            } else {
                this.createDslContext().mergeInto((Table)Tables.STRING_PREFERENCES, DSL.field(Tables.STRING_PREFERENCES.USERNAME), DSL.field(Tables.STRING_PREFERENCES.CATEGORY), DSL.field(Tables.STRING_PREFERENCES.KEY), DSL.field(Tables.STRING_PREFERENCES.VALUE)).key(new Field[]{DSL.field(Tables.STRING_PREFERENCES.USERNAME), DSL.field(Tables.STRING_PREFERENCES.CATEGORY), DSL.field(Tables.STRING_PREFERENCES.KEY)}).values((Object)username, (Object)category, (Object)preferenceName, (Object)value).execute();
            }
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to save into %s %s/%s/%s: %s", Tables.STRING_PREFERENCES.getName(), username, category, preferenceName, value), dae);
        }
    }

    @Override
    public ImmutableSet<String> getSet(String username, String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(new SelectField[0]).from((TableLike)Tables.SET_PREFERENCES).where(new Condition[]{Tables.SET_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.SET_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.SET_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record record : result) {
                builder.add(record.get(Tables.SET_PREFERENCES.VALUE));
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch from %s %s/%s/%s", Tables.SET_PREFERENCES.getName(), username, category, preferenceName), dae);
        }
    }

    @Override
    public void addToSet(String username, String category, String preferenceName, Set<String> values) throws IOException {
        DSLContext dslContext = this.createDslContext();
        for (String value : values) {
            try {
                if (this.sqlDialect.equals((Object)SQLDialect.HSQLDB)) {
                    dslContext.insertInto((Table)Tables.SET_PREFERENCES, Tables.SET_PREFERENCES.USERNAME, Tables.SET_PREFERENCES.CATEGORY, Tables.SET_PREFERENCES.KEY, Tables.SET_PREFERENCES.VALUE).values((Object)username, (Object)category, (Object)preferenceName, (Object)value).onDuplicateKeyIgnore().execute();
                    continue;
                }
                dslContext.mergeInto((Table)Tables.SET_PREFERENCES, DSL.field(Tables.SET_PREFERENCES.USERNAME), DSL.field(Tables.SET_PREFERENCES.CATEGORY), DSL.field(Tables.SET_PREFERENCES.KEY), DSL.field(Tables.SET_PREFERENCES.VALUE)).key(new Field[]{DSL.field(Tables.SET_PREFERENCES.USERNAME), DSL.field(Tables.SET_PREFERENCES.CATEGORY), DSL.field(Tables.SET_PREFERENCES.KEY), DSL.field(Tables.SET_PREFERENCES.VALUE)}).values((Object)username, (Object)category, (Object)preferenceName, (Object)value).execute();
            }
            catch (DataAccessException dae) {
                throw new IOException(String.format("Failed to add into %s %s/%s/%s: %s", Tables.SET_PREFERENCES.getName(), username, category, preferenceName, value), dae);
            }
        }
    }

    @Override
    public void removeFromSet(String username, String category, String preferenceName, @Nullable Set<String> values) throws IOException {
        DSLContext dslContext = this.createDslContext();
        if (values == null) {
            try {
                dslContext.delete((Table)Tables.SET_PREFERENCES).where(new Condition[]{Tables.SET_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.SET_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.SET_PREFERENCES.KEY.eq((Object)preferenceName)).execute();
                return;
            }
            catch (DataAccessException dae) {
                throw new IOException(String.format("Failed to remove all %s %s/%s/%s", Tables.SET_PREFERENCES.getName(), username, category, preferenceName), dae);
            }
        }
        for (String value : values) {
            try {
                dslContext.delete((Table)Tables.SET_PREFERENCES).where(new Condition[]{Tables.SET_PREFERENCES.USERNAME.eq((Object)username)}).and(Tables.SET_PREFERENCES.CATEGORY.eq((Object)category)).and(Tables.SET_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.SET_PREFERENCES.VALUE.eq((Object)value)).execute();
            }
            catch (DataAccessException dae) {
                throw new IOException(String.format("Failed to remove from %s %s/%s/%s: %s", Tables.SET_PREFERENCES.getName(), username, category, preferenceName, value), dae);
            }
        }
    }

    private DSLContext createDslContext() {
        return DSL.using((DataSource)this.dataSource, (SQLDialect)this.sqlDialect);
    }
}

