/*
 * Decompiled with CFR 0.152.
 */
package cloud.toolshed.jsup;

import cloud.toolshed.jsup.UserPreferencesAnalytics;
import cloud.toolshed.jsup.UserPreferencesModule;
import cloud.toolshed.jsup.jooq.generated.Tables;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Range;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.TableImpl;

@Singleton
class UserPreferencesAnalyticsImpl
implements UserPreferencesAnalytics {
    private final DataSource dataSource;
    private final SQLDialect sqlDialect;

    @Inject
    UserPreferencesAnalyticsImpl(@UserPreferencesModule.UserPreferencesInternal DataSource dataSource, @UserPreferencesModule.UserPreferences SQLDialect sqlDialect) {
        this.dataSource = dataSource;
        this.sqlDialect = sqlDialect;
    }

    @Override
    public ImmutableSet<String> getBooleanCategories() throws IOException {
        return this.getCategories(Tables.BOOLEAN_PREFERENCES, Tables.BOOLEAN_PREFERENCES.CATEGORY);
    }

    @Override
    public ImmutableSet<String> getIntegerCategories() throws IOException {
        return this.getCategories(Tables.INTEGER_PREFERENCES, Tables.INTEGER_PREFERENCES.CATEGORY);
    }

    @Override
    public ImmutableSet<String> getFloatCategories() throws IOException {
        return this.getCategories(Tables.FLOAT_PREFERENCES, Tables.FLOAT_PREFERENCES.CATEGORY);
    }

    @Override
    public ImmutableSet<String> getStringCategories() throws IOException {
        return this.getCategories(Tables.STRING_PREFERENCES, Tables.STRING_PREFERENCES.CATEGORY);
    }

    @Override
    public ImmutableSet<String> getSetCategories() throws IOException {
        return this.getCategories(Tables.SET_PREFERENCES, Tables.SET_PREFERENCES.CATEGORY);
    }

    private ImmutableSet<String> getCategories(TableImpl<?> table, TableField<?, String> categoryField) throws IOException {
        try {
            Result result = this.createDslContext().select(categoryField).from(table).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException("Failed to fetch categories from: " + table.getName(), dae);
        }
    }

    @Override
    public ImmutableSet<String> getBooleanPreferenceNames(String category) throws IOException {
        return this.getPreferenceNames(Tables.BOOLEAN_PREFERENCES, Tables.BOOLEAN_PREFERENCES.CATEGORY, category, Tables.BOOLEAN_PREFERENCES.KEY);
    }

    @Override
    public ImmutableSet<String> getIntegerPreferenceNames(String category) throws IOException {
        return this.getPreferenceNames(Tables.INTEGER_PREFERENCES, Tables.INTEGER_PREFERENCES.CATEGORY, category, Tables.INTEGER_PREFERENCES.KEY);
    }

    @Override
    public ImmutableSet<String> getFloatPreferenceNames(String category) throws IOException {
        return this.getPreferenceNames(Tables.FLOAT_PREFERENCES, Tables.FLOAT_PREFERENCES.CATEGORY, category, Tables.FLOAT_PREFERENCES.KEY);
    }

    @Override
    public ImmutableSet<String> getStringPreferenceNames(String category) throws IOException {
        return this.getPreferenceNames(Tables.STRING_PREFERENCES, Tables.STRING_PREFERENCES.CATEGORY, category, Tables.STRING_PREFERENCES.KEY);
    }

    @Override
    public ImmutableSet<String> getSetPreferenceNames(String category) throws IOException {
        return this.getPreferenceNames(Tables.SET_PREFERENCES, Tables.SET_PREFERENCES.CATEGORY, category, Tables.SET_PREFERENCES.KEY);
    }

    private ImmutableSet<String> getPreferenceNames(TableImpl<?> table, TableField<?, String> categoryField, String categoryValue, TableField<?, String> keyField) throws IOException {
        try {
            Result result = this.createDslContext().select(keyField).from(table).where(new Condition[]{categoryField.eq((Object)categoryValue)}).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences from %s for category %s", table.getName(), categoryValue), dae);
        }
    }

    @Override
    public ImmutableMap<String, Boolean> getBooleanPreferencesByUser(String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.BOOLEAN_PREFERENCES.USERNAME, Tables.BOOLEAN_PREFERENCES.VALUE).from((TableLike)Tables.BOOLEAN_PREFERENCES).where(new Condition[]{Tables.BOOLEAN_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.BOOLEAN_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), (Object)((Byte)record.value2() != 0 ? 1 : 0));
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s", Tables.BOOLEAN_PREFERENCES.getName(), category, preferenceName), dae);
        }
    }

    @Override
    public ImmutableSet<String> getUsersWithBooleanPreference(String category, String preferenceName, boolean value) throws IOException {
        try {
            byte byteValue = !value ? (byte)0 : 1;
            Result result = this.createDslContext().select(Tables.BOOLEAN_PREFERENCES.USERNAME).from((TableLike)Tables.BOOLEAN_PREFERENCES).where(new Condition[]{Tables.BOOLEAN_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.BOOLEAN_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.BOOLEAN_PREFERENCES.VALUE.eq((Object)byteValue)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch users from %s for %s/%s with value %s", Tables.BOOLEAN_PREFERENCES.getName(), category, preferenceName, value), dae);
        }
    }

    @Override
    public ImmutableMap<String, Integer> getIntegerPreferencesByUser(String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.INTEGER_PREFERENCES.USERNAME, Tables.INTEGER_PREFERENCES.VALUE).from((TableLike)Tables.INTEGER_PREFERENCES).where(new Condition[]{Tables.INTEGER_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.INTEGER_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s", Tables.INTEGER_PREFERENCES.getName(), category, preferenceName), dae);
        }
    }

    @Override
    public ImmutableMap<String, Integer> getIntegerPreferencesByUser(String category, String preferenceName, Range<Integer> range) throws IOException {
        if (!range.hasLowerBound() && !range.hasUpperBound()) {
            return this.getIntegerPreferencesByUser(category, preferenceName);
        }
        try {
            Result result;
            SelectConditionStep query = this.createDslContext().select(Tables.INTEGER_PREFERENCES.USERNAME, Tables.INTEGER_PREFERENCES.VALUE).from((TableLike)Tables.INTEGER_PREFERENCES).where(new Condition[]{Tables.INTEGER_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.INTEGER_PREFERENCES.KEY.eq((Object)preferenceName));
            if (range.hasLowerBound()) {
                query = range.lowerBoundType().equals((Object)BoundType.CLOSED) ? query.and(Tables.INTEGER_PREFERENCES.VALUE.ge((Object)range.lowerEndpoint())) : query.and(Tables.INTEGER_PREFERENCES.VALUE.gt((Object)range.lowerEndpoint()));
            }
            if (range.hasUpperBound()) {
                query = range.upperBoundType().equals((Object)BoundType.CLOSED) ? query.and(Tables.INTEGER_PREFERENCES.VALUE.le((Object)range.upperEndpoint())) : query.and(Tables.INTEGER_PREFERENCES.VALUE.lt((Object)range.upperEndpoint()));
            }
            if ((result = query.fetch()).isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s and range %s", Tables.INTEGER_PREFERENCES.getName(), category, preferenceName, range.toString()), dae);
        }
    }

    @Override
    public ImmutableSet<String> getUsersWithIntegerPreference(String category, String preferenceName, int value) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.INTEGER_PREFERENCES.USERNAME).from((TableLike)Tables.INTEGER_PREFERENCES).where(new Condition[]{Tables.INTEGER_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.INTEGER_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.INTEGER_PREFERENCES.VALUE.eq((Object)value)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch users from %s for %s/%s with value %s", Tables.INTEGER_PREFERENCES.getName(), category, preferenceName, value), dae);
        }
    }

    @Override
    public ImmutableMap<String, Float> getFloatPreferencesByUser(String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.FLOAT_PREFERENCES.USERNAME, Tables.FLOAT_PREFERENCES.VALUE).from((TableLike)Tables.FLOAT_PREFERENCES).where(new Condition[]{Tables.FLOAT_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.FLOAT_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), (Object)Float.valueOf((float)((Double)record.value2()).doubleValue()));
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s", Tables.FLOAT_PREFERENCES.getName(), category, preferenceName), dae);
        }
    }

    @Override
    public ImmutableMap<String, Float> getFloatPreferencesByUser(String category, String preferenceName, Range<Float> range) throws IOException {
        if (!range.hasLowerBound() && !range.hasUpperBound()) {
            return this.getFloatPreferencesByUser(category, preferenceName);
        }
        try {
            Result result;
            SelectConditionStep query = this.createDslContext().select(Tables.FLOAT_PREFERENCES.USERNAME, Tables.FLOAT_PREFERENCES.VALUE).from((TableLike)Tables.FLOAT_PREFERENCES).where(new Condition[]{Tables.FLOAT_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.FLOAT_PREFERENCES.KEY.eq((Object)preferenceName));
            if (range.hasLowerBound()) {
                query = range.lowerBoundType().equals((Object)BoundType.CLOSED) ? query.and(Tables.FLOAT_PREFERENCES.VALUE.ge((Object)((Float)range.lowerEndpoint()).floatValue())) : query.and(Tables.FLOAT_PREFERENCES.VALUE.gt((Object)((Float)range.lowerEndpoint()).floatValue()));
            }
            if (range.hasUpperBound()) {
                query = range.upperBoundType().equals((Object)BoundType.CLOSED) ? query.and(Tables.FLOAT_PREFERENCES.VALUE.le((Object)((Float)range.upperEndpoint()).floatValue())) : query.and(Tables.FLOAT_PREFERENCES.VALUE.lt((Object)((Float)range.upperEndpoint()).floatValue()));
            }
            if ((result = query.fetch()).isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), (Object)Float.valueOf((float)((Double)record.value2()).doubleValue()));
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s and range %s", Tables.FLOAT_PREFERENCES.getName(), category, preferenceName, range.toString()), dae);
        }
    }

    @Override
    public ImmutableSet<String> getUsersWithFloatPreference(String category, String preferenceName, float value) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.FLOAT_PREFERENCES.USERNAME).from((TableLike)Tables.FLOAT_PREFERENCES).where(new Condition[]{Tables.FLOAT_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.FLOAT_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.FLOAT_PREFERENCES.VALUE.eq((Object)value)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch users from %s for %s/%s with value %s", Tables.FLOAT_PREFERENCES.getName(), category, preferenceName, Float.valueOf(value)), dae);
        }
    }

    @Override
    public ImmutableMap<String, String> getStringPreferencesByUser(String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.STRING_PREFERENCES.USERNAME, Tables.STRING_PREFERENCES.VALUE).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s", Tables.STRING_PREFERENCES.getName(), category, preferenceName), dae);
        }
    }

    @Override
    public ImmutableMap<String, String> getStringPreferencesByUserStartingWith(String category, String preferenceName, String startsWith) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.STRING_PREFERENCES.USERNAME, Tables.STRING_PREFERENCES.VALUE).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.STRING_PREFERENCES.VALUE.startsWith((Object)startsWith)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s starting with %s", Tables.STRING_PREFERENCES.getName(), category, preferenceName, startsWith), dae);
        }
    }

    @Override
    public ImmutableMap<String, String> getStringPreferencesByUserEndingWith(String category, String preferenceName, String endsWith) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.STRING_PREFERENCES.USERNAME, Tables.STRING_PREFERENCES.VALUE).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.STRING_PREFERENCES.VALUE.endsWith((Object)endsWith)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s ending with %s", Tables.STRING_PREFERENCES.getName(), category, preferenceName, endsWith), dae);
        }
    }

    @Override
    public ImmutableMap<String, String> getStringPreferencesByUserContaining(String category, String preferenceName, String containing) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.STRING_PREFERENCES.USERNAME, Tables.STRING_PREFERENCES.VALUE).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.STRING_PREFERENCES.VALUE.contains((Object)containing)).fetch();
            if (result.isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s containing %s", Tables.STRING_PREFERENCES.getName(), category, preferenceName, containing), dae);
        }
    }

    @Override
    public ImmutableSet<String> getUsersWithStringPreference(String category, String preferenceName, String value) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.STRING_PREFERENCES.USERNAME).from((TableLike)Tables.STRING_PREFERENCES).where(new Condition[]{Tables.STRING_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.STRING_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.STRING_PREFERENCES.VALUE.eq((Object)value)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch users from %s for %s/%s with value %s", Tables.STRING_PREFERENCES.getName(), category, preferenceName, value), dae);
        }
    }

    @Override
    public ImmutableSetMultimap<String, String> getSetPreferencesByUser(String category, String preferenceName) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.SET_PREFERENCES.USERNAME, Tables.SET_PREFERENCES.VALUE).from((TableLike)Tables.SET_PREFERENCES).where(new Condition[]{Tables.SET_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.SET_PREFERENCES.KEY.eq((Object)preferenceName)).fetch();
            if (result.isEmpty()) {
                return ImmutableSetMultimap.of();
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Record2 record : result) {
                builder.put(record.value1(), record.value2());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch preferences by user from %s for %s/%s", Tables.SET_PREFERENCES.getName(), category, preferenceName), dae);
        }
    }

    @Override
    public ImmutableSet<String> getUsersWhoseSetPreferenceHas(String category, String preferenceName, String value) throws IOException {
        try {
            Result result = this.createDslContext().select(Tables.SET_PREFERENCES.USERNAME).from((TableLike)Tables.SET_PREFERENCES).where(new Condition[]{Tables.SET_PREFERENCES.CATEGORY.eq((Object)category)}).and(Tables.SET_PREFERENCES.KEY.eq((Object)preferenceName)).and(Tables.SET_PREFERENCES.VALUE.eq((Object)value)).fetch();
            if (result.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Record1 record : result) {
                builder.add(record.value1());
            }
            return builder.build();
        }
        catch (DataAccessException dae) {
            throw new IOException(String.format("Failed to fetch users from %s for %s/%s which has value %s", Tables.SET_PREFERENCES.getName(), category, preferenceName, value), dae);
        }
    }

    private DSLContext createDslContext() {
        return DSL.using((DataSource)this.dataSource, (SQLDialect)this.sqlDialect);
    }
}

