/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.xml;

import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.springboot.RpcProviderBean;
import cloud.tianai.rpc.springboot.exception.RpcProviderParseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProviderBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Class interfaceClass;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(RpcProviderBean.class);
        beanDefinition.setLazyInit(false);
        String interfaceClassStr = element.getAttribute("interface");
        String weightStr = element.getAttribute("weight");
        String ref = element.getAttribute("ref");
        String id = element.getAttribute("id");
        ManagedMap<String, String> parameters = null;
        if (StringUtils.isBlank((CharSequence)interfaceClassStr)) {
            throw new RpcProviderParseException("[interface] \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", element);
        }
        if (StringUtils.isBlank((CharSequence)ref)) {
            throw new RpcProviderParseException("[ref] \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", element);
        }
        try {
            interfaceClass = ClassUtils.forName((String)interfaceClassStr);
            if (!interfaceClass.isInterface()) {
                throw new RpcProviderParseException("[interface] \u5fc5\u987b\u6267\u884c\u63a5\u53e3\u7684\u5168\u8def\u5f84", element);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RpcProviderParseException("[interface] \u5fc5\u987b\u6267\u884c\u63a5\u53e3\u7684\u5168\u8def\u5f84".concat(e.getMessage()), element);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            id = interfaceClass.getSimpleName();
            beanDefinition.getPropertyValues().addPropertyValue("id", (Object)id);
        }
        parameters = ProviderBeanDefinitionParser.parseParameters(element.getChildNodes(), beanDefinition);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        propertyValues.addPropertyValue("parameters", parameters);
        propertyValues.addPropertyValue("ref", (Object)ref);
        if (StringUtils.isNotBlank((CharSequence)weightStr)) {
            int weight = Integer.parseInt(weightStr);
            propertyValues.addPropertyValue("weight", (Object)weight);
        }
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    private static ManagedMap<String, String> parseParameters(NodeList nodeList, RootBeanDefinition beanDefinition) {
        if (nodeList == null) {
            return null;
        }
        ManagedMap parameters = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"parameter".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"parameter".equals(element.getLocalName())) continue;
            if (parameters == null) {
                parameters = new ManagedMap();
            }
            String key = element.getAttribute("key");
            String value = element.getAttribute("value");
            parameters.put((Object)key, (Object)value);
        }
        return parameters;
    }
}

