/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.xml;

import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.springboot.RpcConsumerBean;
import cloud.tianai.rpc.springboot.exception.RpcConsumerParseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConsumerBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Class interfaceClass;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(RpcConsumerBean.class);
        beanDefinition.setLazyInit(false);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        String id = element.getAttribute("id");
        String interfaceClassStr = element.getAttribute("interface");
        String requestTimeoutStr = element.getAttribute("requestTimeout");
        String proxy = element.getAttribute("proxy");
        if (StringUtils.isBlank((CharSequence)interfaceClassStr)) {
            throw new RpcConsumerParseException("[interface] \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", element);
        }
        try {
            interfaceClass = ClassUtils.forName((String)interfaceClassStr);
            if (!interfaceClass.isInterface()) {
                throw new RpcConsumerParseException("[interface] \u5fc5\u987b\u6267\u884c\u63a5\u53e3\u7684\u5168\u8def\u5f84", element);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RpcConsumerParseException("[interface] \u5fc5\u987b\u6267\u884c\u63a5\u53e3\u7684\u5168\u8def\u5f84".concat(e.getMessage()), element);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            id = interfaceClass.getSimpleName();
            beanDefinition.getPropertyValues().addPropertyValue("id", (Object)id);
        }
        if (StringUtils.isNotBlank((CharSequence)requestTimeoutStr)) {
            int requestTimeout = Integer.valueOf(requestTimeoutStr);
            propertyValues.add("requestTimeout", (Object)requestTimeout);
        }
        if (StringUtils.isNotBlank((CharSequence)proxy)) {
            propertyValues.add("proxy", (Object)proxy);
        }
        propertyValues.add("injectedType", (Object)interfaceClass);
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }
}

