/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.annotation;

import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.RpcVersion;
import cloud.tianai.rpc.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.springboot.RpcConsumerBean;
import cloud.tianai.rpc.springboot.RpcConsumerBuilder;
import cloud.tianai.rpc.springboot.annotation.AnnotationRpcConsumerBeanAdapter;
import cloud.tianai.rpc.springboot.annotation.AnnotationRpcProviderHandler;
import cloud.tianai.rpc.springboot.annotation.RpcConsumer;
import cloud.tianai.rpc.springboot.annotation.RpcProvider;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TianAiRpcAnnotationPostProcessor
implements SmartInstantiationAwareBeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(TianAiRpcAnnotationPostProcessor.class);
    private RpcProperties rpcProperties;
    private AnnotationRpcProviderHandler rpcProviderHandler;
    public static final String BANNER = "  _   _                   _                        \n | | (_)                 (_)                       \n | |_ _  __ _ _ __   __ _ _        _ __ _ __   ___ \n | __| |/ _` | '_ \\ / _` | |______| '__| '_ \\ / __|\n | |_| | (_| | | | | (_| | |______| |  | |_) | (__ \n  \\__|_|\\__,_|_| |_|\\__,_|_|      |_|  | .__/ \\___|\n                                       | |         \n" + "                                       |_|   Version:".concat(RpcVersion.getVersion());
    private ConfigurableListableBeanFactory beanFactory;
    private List<RpcClientPostProcessor> rpcClientPostProcessors;
    private final Set<Class<? extends Annotation>> annotationTypes = new LinkedHashSet<Class<? extends Annotation>>(4);
    private final ConcurrentMap<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(32);

    public TianAiRpcAnnotationPostProcessor(RpcProperties rpcProperties, AnnotationRpcProviderHandler rpcProviderHandler) {
        this.rpcProperties = rpcProperties;
        this.printBannerIfNecessary(rpcProperties.getBanner());
        this.rpcProviderHandler = rpcProviderHandler;
        this.annotationTypes.add(RpcConsumer.class);
    }

    private void printBannerIfNecessary(Boolean banner) {
        if (!banner.booleanValue()) {
            return;
        }
        System.out.println(BANNER);
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findInjectionMetadata(bean.getClass(), beanName);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.annotationTypes.iterator().next().getSimpleName() + " dependencies is failed", ex);
        }
        return pvs;
    }

    public InjectionMetadata findInjectionMetadata(Class<?> beanClass, String beanName) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : beanClass.getName();
        return this.injectionMetadataCache.computeIfAbsent(cacheKey, k -> this.buildRpcConsumerMetadata(beanClass));
    }

    private InjectionMetadata buildRpcConsumerMetadata(Class<?> beanClass) {
        if (!AnnotationUtils.isCandidateClass(beanClass, this.annotationTypes)) {
            return InjectionMetadata.EMPTY;
        }
        ArrayList elements = new ArrayList();
        Class<?> targetClass = beanClass;
        do {
            ArrayList currElements = new ArrayList();
            ReflectionUtils.doWithLocalFields(targetClass, field -> {
                MergedAnnotation<?> ann = this.findAnnotation(field);
                if (ann != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (log.isInfoEnabled()) {
                            log.info("Autowired annotation is not supported on static fields: " + field);
                        }
                        return;
                    }
                    currElements.add(new AnnotationFieldElement(field, ann));
                }
            });
            ReflectionUtils.doWithLocalMethods(targetClass, method -> {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                MergedAnnotation<?> ann = this.findAnnotation(method);
                if (ann != null && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        if (log.isInfoEnabled()) {
                            log.info("Autowired annotation is not supported on static methods: " + method);
                        }
                        return;
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                    currElements.add(new AnnotatedMethodElement(method, pd, ann));
                }
            });
            elements.addAll(currElements);
        } while ((targetClass = targetClass.getSuperclass()) != Object.class);
        return new InjectionMetadata(beanClass, elements);
    }

    private MergedAnnotation<?> findAnnotation(AccessibleObject ao) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)ao);
        for (Class<? extends Annotation> type : this.annotationTypes) {
            MergedAnnotation annotation = annotations.get(type);
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return null;
    }

    private List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        String[] names;
        if (this.rpcClientPostProcessors != null) {
            return this.rpcClientPostProcessors;
        }
        LinkedList<RpcClientPostProcessor> result = new LinkedList<RpcClientPostProcessor>();
        for (String name : names = this.beanFactory.getBeanNamesForType(RpcClientPostProcessor.class, true, false)) {
            RpcClientPostProcessor bean = (RpcClientPostProcessor)this.beanFactory.getBean(name, RpcClientPostProcessor.class);
            result.add(bean);
        }
        AnnotationAwareOrderComparator.sort(result);
        this.rpcClientPostProcessors = result;
        return result;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        RpcProvider annotation = (RpcProvider)AnnotationUtils.findAnnotation(bean.getClass(), RpcProvider.class);
        if (annotation == null) {
            return bean;
        }
        if (bean.getClass().isInterface()) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u662f\u4e2a\u63a5\u53e3\uff0c\u4e0d\u662f\u5177\u4f53\u5b9e\u73b0\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        if (bean.getClass().getInterfaces().length < 1) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        this.rpcProviderHandler.registerProvider(bean, annotation);
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public RpcConsumerBean<?> getConsumerBean(AccessibleObject target, MergedAnnotation ann, Class<?> injectedType, Object source) {
        RpcConsumer annotation = null;
        if (RpcConsumer.class.isAssignableFrom(ann.getType())) {
            annotation = (RpcConsumer)AnnotationUtils.findAnnotation((AnnotatedElement)target, RpcConsumer.class);
        }
        if (annotation == null) {
            return new RpcConsumerBean();
        }
        return new AnnotationRpcConsumerBeanAdapter<Object>(injectedType, source, annotation);
    }

    public Object getRpcConsumerValue(Class<?> injectedType, RpcConsumerBean<?> consumerBean) {
        Object result;
        try {
            result = this.beanFactory.getBean(injectedType);
        }
        catch (NoSuchBeanDefinitionException e) {
            RpcConsumerBuilder rpcConsumerBuilder = new RpcConsumerBuilder(injectedType, consumerBean, this.rpcProperties, this.getRpcClientPostProcessors());
            result = rpcConsumerBuilder.build();
            this.beanFactory.registerSingleton(result.getClass().getSimpleName(), result);
        }
        return result;
    }

    private class AnnotatedMethodElement
    extends InjectionMetadata.InjectedElement {
        private final Method method;
        private MergedAnnotation ann;

        protected AnnotatedMethodElement(Method method, PropertyDescriptor pd, MergedAnnotation ann) {
            super((Member)method, pd);
            this.method = method;
            this.ann = ann;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            assert (this.pd != null);
            Class<?> injectedType = this.pd.getPropertyType();
            RpcConsumerBean<?> consumerBean = TianAiRpcAnnotationPostProcessor.this.getConsumerBean(this.method, this.ann, injectedType, bean);
            Object value = TianAiRpcAnnotationPostProcessor.this.getRpcConsumerValue(injectedType, consumerBean);
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(bean, value);
        }
    }

    private class AnnotationFieldElement
    extends InjectionMetadata.InjectedElement {
        private MergedAnnotation ann;

        public AnnotationFieldElement(Field field, MergedAnnotation<?> ann) {
            super((Member)field, null);
            this.ann = ann;
        }

        protected void inject(Object target, String beanName, PropertyValues pvs) throws Throwable {
            Field field = (Field)this.member;
            Class<?> injectedType = field.getType();
            RpcConsumerBean<?> consumerBean = TianAiRpcAnnotationPostProcessor.this.getConsumerBean(field, this.ann, injectedType, target);
            Object value = TianAiRpcAnnotationPostProcessor.this.getRpcConsumerValue(injectedType, consumerBean);
            ReflectionUtils.makeAccessible((Field)field);
            field.set(target, value);
        }
    }
}

