/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot;

import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.bootstrap.ServerBootstrap;
import cloud.tianai.rpc.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import java.util.List;

public class ServerBootstrapBuilder {
    private static final RpcProperties DEFAULT_RPC_PROPERTIES = new RpcProperties();
    private RpcProperties rpcProperties = DEFAULT_RPC_PROPERTIES;
    private List<RpcInvocationPostProcessor> rpcInvocationPostProcessors;
    private ServerBootstrap serverBootstrap;

    public ServerBootstrap buildAndStart() {
        this.build().start();
        return this.serverBootstrap;
    }

    public ServerBootstrap build() {
        ServerBootstrap serverBootstrap;
        this.serverBootstrap = serverBootstrap = new ServerBootstrap();
        serverBootstrap.registry(this.rpcProperties.getRegistry().getURL()).codec(this.rpcProperties.getCodec()).timeout(this.rpcProperties.getServer().getTimeout()).protocol(this.rpcProperties.getServer().getServer()).workThreads(this.rpcProperties.getWorkerThreads()).port(this.rpcProperties.getServer().getPort()).bossThreads(this.rpcProperties.getServer().getBossThreads());
        List<RpcInvocationPostProcessor> rpcInvocationPostProcessors = this.getRpcInvocationPostProcessors();
        if (CollectionUtils.isNotEmpty(rpcInvocationPostProcessors)) {
            rpcInvocationPostProcessors.forEach(arg_0 -> ((ServerBootstrap)serverBootstrap).addRpcInvocationPostProcessor(arg_0));
        }
        return serverBootstrap;
    }

    public ServerBootstrapBuilder setRpcProperties(RpcProperties rpcProperties) {
        this.rpcProperties = rpcProperties;
        return this;
    }

    public RpcProperties getRpcProperties() {
        return this.rpcProperties;
    }

    public ServerBootstrapBuilder setRpcInvocationPostProcessors(List<RpcInvocationPostProcessor> rpcInvocationPostProcessors) {
        this.rpcInvocationPostProcessors = rpcInvocationPostProcessors;
        return this;
    }

    public List<RpcInvocationPostProcessor> getRpcInvocationPostProcessors() {
        return this.rpcInvocationPostProcessors;
    }
}

