/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot;

import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.client.proxy.RpcProxyFactory;
import cloud.tianai.rpc.core.client.proxy.RpcProxyType;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.springboot.RpcConsumerBean;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcConsumerBuilder {
    private static final Logger log = LoggerFactory.getLogger(RpcConsumerBuilder.class);
    private Class<?> type;
    private RpcConsumerBean<?> rpcConsumerBean;
    private RpcProperties rpcProperties;
    private List<RpcClientPostProcessor> rpcClientPostProcessors;

    public RpcConsumerBuilder(Class<?> type, RpcConsumerBean<?> rpcConsumerBean, RpcProperties rpcProperties, List<RpcClientPostProcessor> rpcClientPostProcessors) {
        this.type = type;
        this.rpcConsumerBean = rpcConsumerBean;
        this.rpcProperties = rpcProperties;
        this.rpcClientPostProcessors = rpcClientPostProcessors;
    }

    public Object build() {
        return this.build((clazz, c) -> null);
    }

    public Object build(BiFunction<Class<?>, RpcConsumerBean, Object> cache) {
        Object source = cache.apply(this.type, this.rpcConsumerBean);
        if (source == null) {
            source = this.createRpcConsumer();
            log.info("TIANAI-RPC CLIENT create: {}", this.type);
        }
        return source;
    }

    private Object createRpcConsumer() {
        RpcClientConfiguration rpcConsumerProp = this.findRpcConsumerConfig();
        RpcProxyType rpcProxyType = this.getRpcProxyType(this.rpcConsumerBean, this.rpcProperties);
        Object proxy = RpcProxyFactory.create(this.type, (RpcClientConfiguration)rpcConsumerProp, (RpcProxyType)rpcProxyType);
        return proxy;
    }

    private RpcProxyType getRpcProxyType(RpcConsumerBean rpcConsumer, RpcProperties prop) {
        String proxy = rpcConsumer.getProxy();
        RpcProxyType rpcProxyType = null;
        if (StringUtils.isNotBlank((CharSequence)proxy)) {
            try {
                rpcProxyType = RpcProxyType.valueOf((String)proxy);
            }
            catch (IllegalArgumentException e) {
                rpcProxyType = null;
            }
        }
        if (rpcProxyType != null) {
            return rpcProxyType;
        }
        rpcProxyType = prop.getClient().getDefaultProxyType();
        if (rpcProxyType == null) {
            rpcProxyType = RpcProxyType.JAVASSIST_PROXY;
        }
        return rpcProxyType;
    }

    private RpcClientConfiguration findRpcConsumerConfig() {
        RpcClientConfiguration properties = new RpcClientConfiguration();
        if (this.rpcProperties.getClient() == null) {
            throw new RpcException("TIANAI-RPC \u8bfb\u53d6\u516c\u5171\u5ba2\u6237\u7aef\u6d88\u606f\u5931\u8d25\uff0c \u672a\u914d\u7f6e [RpcConsumerProperties]");
        }
        properties.setCodec(this.rpcProperties.getCodec());
        properties.setRegistryUrl(this.rpcProperties.getRegistry().getURL());
        properties.setProtocol(this.rpcProperties.getClient().getClient());
        properties.addParameter("workerThreads", (Object)this.rpcProperties.getWorkerThreads());
        properties.setRetry(this.rpcProperties.getClient().getRetry());
        properties.setLoadBalance(this.rpcProperties.getClient().getLoadbalance());
        int requestTimeout = this.rpcConsumerBean.getRequestTimeout();
        if (requestTimeout <= 0) {
            requestTimeout = this.rpcProperties.getClient().getDefaultRequestTimeout();
        }
        properties.setTimeout(Integer.valueOf(requestTimeout));
        properties.setRequestTimeout(Integer.valueOf(requestTimeout));
        properties.setLazyLoadRegistry(this.rpcProperties.getClient().isLazyLoadRegistry());
        properties.setLazyStartRpcClient(this.rpcProperties.getClient().isLazyStartRpcClient());
        List<RpcClientPostProcessor> rpcClientPostProcessors = this.getRpcClientPostProcessors();
        if (CollectionUtils.isNotEmpty(rpcClientPostProcessors)) {
            rpcClientPostProcessors.forEach(arg_0 -> ((RpcClientConfiguration)properties).addRpcClientPostProcessor(arg_0));
        }
        return properties;
    }

    private RpcClientConfiguration findCommonProp() {
        RpcClientConfiguration properties = new RpcClientConfiguration();
        if (this.rpcProperties.getClient() == null) {
            throw new RpcException("TIANAI-RPC \u8bfb\u53d6\u516c\u5171\u5ba2\u6237\u7aef\u6d88\u606f\u5931\u8d25\uff0c \u672a\u914d\u7f6e [RpcConsumerProperties]");
        }
        properties.setCodec(this.rpcProperties.getCodec());
        properties.setRegistryUrl(this.rpcProperties.getRegistry().getURL());
        properties.setProtocol(this.rpcProperties.getClient().getClient());
        properties.addParameter("workerThreads", (Object)this.rpcProperties.getWorkerThreads());
        properties.setRetry(this.rpcProperties.getClient().getRetry());
        properties.setLoadBalance(this.rpcProperties.getClient().getLoadbalance());
        return properties;
    }

    public Class<?> getType() {
        return this.type;
    }

    public RpcConsumerBean<?> getRpcConsumerBean() {
        return this.rpcConsumerBean;
    }

    public RpcProperties getRpcProperties() {
        return this.rpcProperties;
    }

    public List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        return this.rpcClientPostProcessors;
    }
}

