/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot;

import cloud.tianai.rpc.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.springboot.RpcConsumerBuilder;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class RpcConsumerBean<T>
implements FactoryBean<T>,
BeanFactoryAware {
    private static List<RpcClientPostProcessor> rpcClientPostProcessors;
    private String id;
    private int requestTimeout;
    private String proxy;
    private Class<?> injectedType;
    private T source;
    private ConfigurableListableBeanFactory beanFactory;

    public RpcConsumerBean() {
    }

    public RpcConsumerBean(int requestTimeout, String proxy, Class<?> injectedType, T source) {
        this.requestTimeout = requestTimeout;
        this.proxy = proxy;
        this.injectedType = injectedType;
        this.id = injectedType.getSimpleName();
        this.source = source;
    }

    public RpcConsumerBean(String id, int requestTimeout, String proxy, Class<?> injectedType, T source) {
        this.requestTimeout = requestTimeout;
        this.proxy = proxy;
        this.injectedType = injectedType;
        this.id = id;
        this.source = source;
    }

    public T getObject() throws Exception {
        if (this.source == null) {
            this.init();
        }
        return this.source;
    }

    private void init() {
        RpcProperties rpcProperties = (RpcProperties)this.beanFactory.getBean(RpcProperties.class);
        List<RpcClientPostProcessor> rpcClientPostProcessors = this.getRpcClientPostProcessors();
        RpcConsumerBuilder rpcConsumerBuilder = new RpcConsumerBuilder(this.injectedType, this, rpcProperties, rpcClientPostProcessors);
        this.source = rpcConsumerBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        if (rpcClientPostProcessors != null) return rpcClientPostProcessors;
        Class<RpcConsumerBean> clazz = RpcConsumerBean.class;
        synchronized (RpcConsumerBean.class) {
            String[] names;
            if (rpcClientPostProcessors != null) return rpcClientPostProcessors;
            rpcClientPostProcessors = new LinkedList<RpcClientPostProcessor>();
            for (String name : names = this.beanFactory.getBeanNamesForType(RpcClientPostProcessor.class, true, false)) {
                RpcClientPostProcessor bean = (RpcClientPostProcessor)this.beanFactory.getBean(name, RpcClientPostProcessor.class);
                rpcClientPostProcessors.add(bean);
            }
            AnnotationAwareOrderComparator.sort(rpcClientPostProcessors);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rpcClientPostProcessors;
        }
    }

    public Class<?> getObjectType() {
        return this.injectedType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public String getId() {
        return this.id;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Class<?> getInjectedType() {
        return this.injectedType;
    }

    public T getSource() {
        return this.source;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setInjectedType(Class<?> injectedType) {
        this.injectedType = injectedType;
    }

    public void setSource(T source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcConsumerBean)) {
            return false;
        }
        RpcConsumerBean other = (RpcConsumerBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        Class<?> this$injectedType = this.getInjectedType();
        Class<?> other$injectedType = other.getInjectedType();
        if (this$injectedType == null ? other$injectedType != null : !this$injectedType.equals(other$injectedType)) {
            return false;
        }
        T this$source = this.getSource();
        T other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        ConfigurableListableBeanFactory this$beanFactory = this.getBeanFactory();
        ConfigurableListableBeanFactory other$beanFactory = other.getBeanFactory();
        return !(this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcConsumerBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + this.getRequestTimeout();
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        Class<?> $injectedType = this.getInjectedType();
        result = result * 59 + ($injectedType == null ? 43 : $injectedType.hashCode());
        T $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        ConfigurableListableBeanFactory $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        return result;
    }

    public String toString() {
        return "RpcConsumerBean(id=" + this.getId() + ", requestTimeout=" + this.getRequestTimeout() + ", proxy=" + this.getProxy() + ", injectedType=" + this.getInjectedType() + ", source=" + this.getSource() + ", beanFactory=" + this.getBeanFactory() + ")";
    }
}

