/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot;

import cloud.tianai.rpc.core.bootstrap.ServerBootstrap;
import cloud.tianai.rpc.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.rpc.springboot.RpcProviderBean;
import cloud.tianai.rpc.springboot.RpcProviderHandler;
import cloud.tianai.rpc.springboot.ServerBootstrapBuilder;
import cloud.tianai.rpc.springboot.exception.RpcProviderRegisterException;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;

public class DefaultRpcProviderHandler
implements RpcProviderHandler,
BeanFactoryAware,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRpcProviderHandler.class);
    private Map<Object, RpcProviderBean> rpcProviderMap = new ConcurrentHashMap<Object, RpcProviderBean>(16);
    private RpcProperties rpcProperties;
    private ConfigurableListableBeanFactory beanFactory;
    private boolean autoInit;
    private AtomicBoolean init = new AtomicBoolean(false);

    public DefaultRpcProviderHandler(RpcProperties rpcProperties, boolean autoInit) {
        this.rpcProperties = rpcProperties;
        this.autoInit = autoInit;
    }

    @Override
    public RpcProperties getRpcProperties() {
        return this.rpcProperties;
    }

    @Override
    public void registerProvider(Object bean, RpcProviderBean providerBean) {
        if (this.isInit()) {
            throw new RpcProviderRegisterException("\u8bf7\u5728 \u6267\u884c init() \u65b9\u6cd5\u524d\u8fdb\u884c\u6ce8\u518cProvider");
        }
        this.rpcProviderMap.remove(bean);
        this.rpcProviderMap.put(bean, providerBean);
    }

    @Override
    public RpcProviderBean getProvider(Object bean) {
        return this.rpcProviderMap.get(bean);
    }

    @Override
    public Collection<RpcProviderBean> listProviderBeans() {
        return this.rpcProviderMap.values();
    }

    @Override
    public Collection<Object> listProviderSources() {
        return this.rpcProviderMap.keySet();
    }

    @Override
    public void init() {
        ServerBootstrap serverBootstrap;
        if (!this.init.compareAndSet(false, true)) {
            log.warn("[{}] \u5df2\u7ecf\u88ab\u521d\u59cb\u5316\uff0c\u4e0d\u53ef\u91cd\u590d\u8c03\u7528", (Object)this.getClass().getName());
            return;
        }
        if (this.getRpcProviderMap().isEmpty()) {
            return;
        }
        ServerBootstrap finalServerBootstrap = serverBootstrap = this.getServerBootstrap();
        this.getRpcProviderMap().forEach((bean, providerBean) -> {
            Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
            Class<?> interfaceClass = targetClass.getInterfaces()[0];
            HashMap<String, String> paramMap = new HashMap<String, String>(8);
            Map<String, String> parameters = providerBean.getParameters();
            if (!CollectionUtils.isEmpty(parameters)) {
                parameters.forEach(paramMap::put);
            }
            paramMap.put("weight", String.valueOf(providerBean.getWeight()));
            finalServerBootstrap.register(interfaceClass, bean, paramMap);
            log.info("TIANAI-RPC SERVER register[{}]", (Object)interfaceClass.getName());
        });
        this.rpcProviderMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap getServerBootstrap() {
        ServerBootstrap serverBootstrap;
        try {
            serverBootstrap = (ServerBootstrap)this.beanFactory.getBean(ServerBootstrap.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            DefaultRpcProviderHandler defaultRpcProviderHandler = this;
            synchronized (defaultRpcProviderHandler) {
                try {
                    serverBootstrap = (ServerBootstrap)this.beanFactory.getBean(ServerBootstrap.class);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    serverBootstrap = this.createServerBootstrap();
                    this.beanFactory.registerSingleton(serverBootstrap.getClass().getName(), (Object)serverBootstrap);
                }
            }
        }
        return serverBootstrap;
    }

    private ServerBootstrap createServerBootstrap() {
        List<RpcInvocationPostProcessor> rpcInvocationPostProcessors = this.getRpcInvocationPostProcessors();
        ServerBootstrap serverBootstrap = new ServerBootstrapBuilder().setRpcProperties(this.rpcProperties).setRpcInvocationPostProcessors(rpcInvocationPostProcessors).buildAndStart();
        return serverBootstrap;
    }

    private List<RpcInvocationPostProcessor> getRpcInvocationPostProcessors() {
        String[] names;
        LinkedList<RpcInvocationPostProcessor> result = new LinkedList<RpcInvocationPostProcessor>();
        for (String name : names = this.beanFactory.getBeanNamesForType(RpcInvocationPostProcessor.class, true, false)) {
            RpcInvocationPostProcessor bean = (RpcInvocationPostProcessor)this.beanFactory.getBean(name, RpcInvocationPostProcessor.class);
            result.add(bean);
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    @Override
    public boolean isInit() {
        return this.init.get();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setRpcProviderMap(Map<Object, RpcProviderBean> rpcProviderMap) {
        this.rpcProviderMap = rpcProviderMap;
    }

    public Map<Object, RpcProviderBean> getRpcProviderMap() {
        return this.rpcProviderMap;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (this.autoInit && !this.isInit()) {
            this.init();
        }
    }
}

