/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.annotation;

import cloud.tianai.remoting.api.RpcClientPostProcessor;
import cloud.tianai.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.bootstrap.ServerBootstrap;
import cloud.tianai.rpc.core.client.proxy.RpcProxyFactory;
import cloud.tianai.rpc.core.client.proxy.RpcProxyType;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.configuration.RpcServerConfiguration;
import cloud.tianai.rpc.springboot.annotation.RpcConsumer;
import cloud.tianai.rpc.springboot.annotation.RpcProvider;
import cloud.tianai.rpc.springboot.properties.RpcConsumerProperties;
import cloud.tianai.rpc.springboot.properties.RpcProperties;
import cloud.tianai.rpc.springboot.properties.RpcProviderProperties;
import cloud.tianai.rpc.springboot.properties.RpcReqistryProperties;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;

public class TianAiRpcAnnotationBean
implements BeanPostProcessor,
ApplicationContextAware,
BeanFactoryAware,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(TianAiRpcAnnotationBean.class);
    private RpcClientConfiguration prop;
    private RpcProperties rpcProperties;
    private RpcConsumerProperties rpcConsumerProperties;
    private RpcReqistryProperties rpcReqistryProperties;
    private RpcProviderProperties rpcProviderProperties;
    private AbstractApplicationContext applicationContext;
    private Map<Object, RpcProvider> rpcProviderMap = new ConcurrentHashMap<Object, RpcProvider>(16);
    public static final String BANNER = "  _   _                   _                        \n | | (_)                 (_)                       \n | |_ _  __ _ _ __   __ _ _        _ __ _ __   ___ \n | __| |/ _` | '_ \\ / _` | |______| '__| '_ \\ / __|\n | |_| | (_| | | | | (_| | |______| |  | |_) | (__ \n  \\__|_|\\__,_|_| |_|\\__,_|_|      |_|  | .__/ \\___|\n                                       | |         \n                                       |_|         ";
    private ConfigurableListableBeanFactory beanFactory;

    public TianAiRpcAnnotationBean(RpcConsumerProperties rpcConsumerProperties, RpcReqistryProperties rpcReqistryProperties, RpcProviderProperties rpcProviderProperties, RpcProperties rpcProperties) {
        this.rpcConsumerProperties = rpcConsumerProperties;
        this.rpcProperties = rpcProperties;
        this.rpcReqistryProperties = rpcReqistryProperties;
        this.rpcProviderProperties = rpcProviderProperties;
        this.printBannerIfNecessary(rpcProperties.getBanner());
    }

    private void printBannerIfNecessary(Boolean banner) {
        if (!banner.booleanValue()) {
            return;
        }
        System.out.println(BANNER);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            Object value;
            RpcConsumer rpcConsumer;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((rpcConsumer = field.getAnnotation(RpcConsumer.class)) == null || (value = this.getValue(rpcConsumer, field)) == null) continue;
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                log.error("Failed to init remote service RpcConsumer at filed " + field.getName() + " in class " + bean.getClass().getName() + ", cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }

    private Object getValue(RpcConsumer rpcConsumer, Field field) {
        Class<?> type = field.getType();
        Object bean = null;
        try {
            bean = this.beanFactory.getBean(type);
            return bean;
        }
        catch (NoSuchBeanDefinitionException e) {
            bean = this.createRpcConsumer(type, rpcConsumer);
            this.beanFactory.registerSingleton(bean.getClass().getSimpleName(), bean);
            log.info("TIANAI-RPC CLIENT create:" + type);
            return bean;
        }
    }

    private Object createRpcConsumer(Class<?> type, RpcConsumer rpcConsumer) {
        RpcClientConfiguration rpcConsumerProp = this.findRpcConsumerConfig(rpcConsumer);
        RpcProxyType rpcProxyType = this.getRpcProxyType(rpcConsumer, this.rpcConsumerProperties);
        Object proxy = RpcProxyFactory.create(type, (RpcClientConfiguration)rpcConsumerProp, (RpcProxyType)rpcProxyType);
        return proxy;
    }

    private RpcProxyType getRpcProxyType(RpcConsumer rpcConsumer, RpcConsumerProperties rpcConsumerProperties) {
        RpcProxyType rpcProxyType;
        String proxy = rpcConsumer.proxy();
        try {
            rpcProxyType = RpcProxyType.valueOf((String)proxy);
        }
        catch (IllegalArgumentException e) {
            rpcProxyType = null;
        }
        if (rpcProxyType != null) {
            return rpcProxyType;
        }
        rpcProxyType = rpcConsumerProperties.getDefaultProxyType();
        if (rpcProxyType == null) {
            rpcProxyType = RpcProxyType.JAVASSIST_PROXY;
        }
        return rpcProxyType;
    }

    private RpcClientConfiguration findRpcConsumerConfig(RpcConsumer rpcConsumer) {
        RpcClientConfiguration resultProp = this.prop != null ? new RpcClientConfiguration() : (this.prop = this.findCommonProp());
        int requestTimeout = rpcConsumer.requestTimeout();
        if (requestTimeout <= 0) {
            requestTimeout = this.rpcConsumerProperties.getDefaultRequestTimeout();
        }
        resultProp.setTimeout(Integer.valueOf(requestTimeout));
        resultProp.setRequestTimeout(Integer.valueOf(requestTimeout));
        resultProp.setLazyLoadRegistry(this.rpcConsumerProperties.isLazyLoadRegistry());
        resultProp.setLazyStartRpcClient(this.rpcConsumerProperties.isLazyStartRpcClient());
        List<RpcClientPostProcessor> rpcClientPostProcessors = this.getRpcClientPostProcessors();
        if (CollectionUtils.isNotEmpty(rpcClientPostProcessors)) {
            AnnotationAwareOrderComparator.sort(rpcClientPostProcessors);
            rpcClientPostProcessors.forEach(arg_0 -> ((RpcClientConfiguration)resultProp).addRpcClientPostProcessor(arg_0));
        }
        return resultProp;
    }

    private List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        String[] names;
        LinkedList<RpcClientPostProcessor> result = new LinkedList<RpcClientPostProcessor>();
        for (String name : names = this.beanFactory.getBeanNamesForType(RpcClientPostProcessor.class, true, false)) {
            RpcClientPostProcessor bean = (RpcClientPostProcessor)this.beanFactory.getBean(name, RpcClientPostProcessor.class);
            result.add(bean);
        }
        return result;
    }

    private List<RpcInvocationPostProcessor> getRpcInvocationPostProcessors() {
        String[] names;
        LinkedList<RpcInvocationPostProcessor> result = new LinkedList<RpcInvocationPostProcessor>();
        for (String name : names = this.beanFactory.getBeanNamesForType(RpcInvocationPostProcessor.class, true, false)) {
            RpcInvocationPostProcessor bean = (RpcInvocationPostProcessor)this.beanFactory.getBean(name, RpcInvocationPostProcessor.class);
            result.add(bean);
        }
        return result;
    }

    private RpcClientConfiguration findCommonProp() {
        RpcClientConfiguration properties = new RpcClientConfiguration();
        if (this.rpcConsumerProperties == null) {
            throw new RpcException("TIANAI-RPC \u8bfb\u53d6\u516c\u5171\u5ba2\u6237\u7aef\u6d88\u606f\u5931\u8d25\uff0c \u672a\u914d\u7f6e [RpcConsumerProperties]");
        }
        properties.setCodec(this.rpcProperties.getCodec());
        properties.setRegistryUrl(this.rpcReqistryProperties.getURL());
        properties.setProtocol(this.rpcConsumerProperties.getClient());
        properties.setWorkerThread(this.rpcProperties.getWorkerThreads());
        properties.setRetry(this.rpcConsumerProperties.getRetry());
        properties.setLoadBalance(this.rpcConsumerProperties.getLoadbalance());
        return properties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        RpcProvider annotation = (RpcProvider)AnnotationUtils.findAnnotation(bean.getClass(), RpcProvider.class);
        if (annotation == null) {
            return bean;
        }
        if (bean.getClass().isInterface()) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u662f\u4e2a\u63a5\u53e3\uff0c\u4e0d\u662f\u5177\u4f53\u5b9e\u73b0\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        if (bean.getClass().getInterfaces().length < 1) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        this.rpcProviderMap.put(bean, annotation);
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (AbstractApplicationContext)applicationContext;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ServerBootstrap serverBootstrap;
        if (this.rpcProviderMap.isEmpty()) {
            return;
        }
        try {
            serverBootstrap = (ServerBootstrap)this.beanFactory.getBean(ServerBootstrap.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            serverBootstrap = this.createServerBootstrap();
            this.beanFactory.registerSingleton(serverBootstrap.getClass().getName(), (Object)serverBootstrap);
        }
        ServerBootstrap finalServerBootstrap = serverBootstrap;
        this.rpcProviderMap.forEach((bean, anno) -> {
            Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
            Class<?> interfaceClass = targetClass.getInterfaces()[0];
            finalServerBootstrap.register(interfaceClass, bean, Integer.valueOf(anno.weight()));
            log.info("TIANAI-RPC SERVER register[{}]", (Object)interfaceClass.getName());
        });
        this.rpcProviderMap.clear();
    }

    private ServerBootstrap createServerBootstrap() {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        RpcServerConfiguration prop = serverBootstrap.getProp();
        prop.setRegistryUrl(this.rpcReqistryProperties.getURL());
        prop.setCodec(this.rpcProperties.getCodec());
        prop.setTimeout(this.rpcProviderProperties.getTimeout());
        prop.setProtocol(this.rpcProviderProperties.getServer());
        prop.setWorkerThread(this.rpcProperties.getWorkerThreads());
        prop.setPort(this.rpcProviderProperties.getPort());
        prop.setBossThreads(this.rpcProviderProperties.getBossThreads());
        List<RpcInvocationPostProcessor> rpcInvocationPostProcessors = this.getRpcInvocationPostProcessors();
        if (CollectionUtils.isNotEmpty(rpcInvocationPostProcessors)) {
            AnnotationAwareOrderComparator.sort(rpcInvocationPostProcessors);
            rpcInvocationPostProcessors.forEach(arg_0 -> ((RpcServerConfiguration)prop).addRpcInvocationPostProcessor(arg_0));
        }
        serverBootstrap.start();
        return serverBootstrap;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

