/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.autoconfiguration;

import cloud.tianai.rpc.core.bootstrap.ServerBootstrap;
import cloud.tianai.rpc.springboot.autoconfiguration.AnnotationBeanProcessor;
import cloud.tianai.rpc.springboot.autoconfiguration.RpcConsumerProperties;
import cloud.tianai.rpc.springboot.autoconfiguration.RpcProperties;
import cloud.tianai.rpc.springboot.autoconfiguration.RpcProviderProperties;
import cloud.tianai.rpc.springboot.autoconfiguration.RpcReqistryProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RpcConsumerProperties.class, RpcProperties.class, RpcReqistryProperties.class, RpcProviderProperties.class})
public class RpcAutoConfiguration
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean
    public AnnotationBeanProcessor annotationBeanProcessor(RpcConsumerProperties rpcConsumerProperties, RpcProperties rpcProperties, RpcReqistryProperties rpcReqistryProperties) {
        return new AnnotationBeanProcessor(rpcConsumerProperties, rpcReqistryProperties, rpcProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"tianai-rpc.server.enable"}, havingValue="true")
    public ServerBootstrap serverBootstrap(RpcProviderProperties rpcProviderProperties, RpcProperties rpcProperties, RpcReqistryProperties rpcReqistryProperties) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.codec(rpcProperties.getCodec()).timeout(rpcProviderProperties.getTimeout()).registry(rpcReqistryProperties.getURL()).server(rpcProviderProperties.getServer()).port(rpcProviderProperties.getPort());
        serverBootstrap.start();
        return serverBootstrap;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

