/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.springboot.autoconfiguration;

import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.bootstrap.ServerBootstrap;
import cloud.tianai.rpc.core.client.proxy.impl.JdkRpcProxy;
import cloud.tianai.rpc.springboot.annotation.RpcConsumer;
import cloud.tianai.rpc.springboot.annotation.RpcProvider;
import cloud.tianai.rpc.springboot.autoconfiguration.RpcConsumerProperties;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class AnnotationBeanProcessor
implements BeanPostProcessor,
BeanFactoryPostProcessor,
ApplicationContextAware,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBeanProcessor.class);
    private Properties prop;
    private RpcConsumerProperties rpcConsumerProperties;
    private AbstractApplicationContext applicationContext;
    private Map<Object, RpcProvider> rpcProviderMap = new ConcurrentHashMap<Object, RpcProvider>(16);
    private ConfigurableListableBeanFactory beanFactory;

    public AnnotationBeanProcessor(RpcConsumerProperties rpcConsumerProperties) {
        this.rpcConsumerProperties = rpcConsumerProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            Object value;
            RpcConsumer rpcConsumer;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((rpcConsumer = field.getAnnotation(RpcConsumer.class)) == null || (value = this.getValue(rpcConsumer, field)) == null) continue;
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                log.error("Failed to init remote service RpcConsumer at filed " + field.getName() + " in class " + bean.getClass().getName() + ", cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }

    private Object getValue(RpcConsumer rpcConsumer, Field field) {
        Class<?> type = field.getType();
        Object bean = null;
        try {
            bean = this.beanFactory.getBean(type);
            return bean;
        }
        catch (NoSuchBeanDefinitionException e) {
            bean = this.createRpcConsumer(type, rpcConsumer);
            this.beanFactory.registerSingleton(bean.getClass().getSimpleName(), bean);
            log.info("TIANAI-RPC CLIENT create:" + type);
            return bean;
        }
    }

    private Object createRpcConsumer(Class<?> type, RpcConsumer rpcConsumer) {
        Properties rpcConsumerProp = this.findRpcConsumerConfig(rpcConsumer);
        JdkRpcProxy rpcProxy = new JdkRpcProxy();
        Object proxy = rpcProxy.createProxy(type, rpcConsumerProp, true, true);
        return proxy;
    }

    private Properties findRpcConsumerConfig(RpcConsumer rpcConsumer) {
        Properties resultProp = this.prop != null ? this.prop : (this.prop = this.findCommonProp());
        resultProp.setProperty("rpc.remoting.timeout", String.valueOf(rpcConsumer.timeout()));
        resultProp.setProperty("rpc.remoting.request.timeout", String.valueOf(rpcConsumer.requestTimeout()));
        return resultProp;
    }

    private Properties findCommonProp() {
        Properties properties = new Properties();
        if (this.rpcConsumerProperties == null) {
            throw new RpcException("TIANAI-RPC \u8bfb\u53d6\u516c\u5171\u5ba2\u6237\u7aef\u6d88\u606f\u5931\u8d25\uff0c \u672a\u914d\u7f6e [RpcConsumerProperties]");
        }
        properties.setProperty("rpc.remoting.codec", this.rpcConsumerProperties.getCodec());
        properties.setProperty("rpc.remoting.register", this.rpcConsumerProperties.getRegister());
        properties.setProperty("rpc.remoting.registry.host", this.rpcConsumerProperties.getRegisterHost());
        properties.setProperty("rpc.remoting.registry.port", String.valueOf(this.rpcConsumerProperties.getRegisterPort()));
        properties.setProperty("rpc.remoting.protocol", String.valueOf(this.rpcConsumerProperties.getClient()));
        properties.setProperty("rpc.remoting.worker.threads", String.valueOf(this.rpcConsumerProperties.getWorkerThreads()));
        return properties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        RpcProvider annotation = (RpcProvider)AnnotationUtils.findAnnotation(bean.getClass(), RpcProvider.class);
        if (annotation == null) {
            return bean;
        }
        if (bean.getClass().isInterface()) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u662f\u4e2a\u63a5\u53e3\uff0c\u4e0d\u662f\u5177\u4f53\u5b9e\u73b0\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        if (bean.getClass().getInterfaces().length < 1) {
            throw new RpcException("TIANAI-RPC \u6ce8\u518c [" + bean.getClass() + "], \u5931\u8d25\uff0c \u8be5\u7c7b\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u65e0\u6cd5\u6ce8\u518c");
        }
        this.rpcProviderMap.put(bean, annotation);
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (AbstractApplicationContext)applicationContext;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ServerBootstrap serverBootstrap = null;
        try {
            serverBootstrap = (ServerBootstrap)this.applicationContext.getBean(ServerBootstrap.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            serverBootstrap = null;
        }
        if (!this.rpcProviderMap.isEmpty()) {
            if (serverBootstrap == null) {
                throw new RpcException("TIANAI-RPC \u6ce8\u518cserver\u65f6\u672a\u627e\u5230 [ServerBootstrap], \u5f85\u6ce8\u518c\u7684\u7c7b:" + this.rpcProviderMap.keySet());
            }
            ServerBootstrap finalServerBootstrap = serverBootstrap;
            this.rpcProviderMap.forEach((bean, anno) -> {
                Class<?> interfaceClass = bean.getClass().getInterfaces()[0];
                finalServerBootstrap.register(interfaceClass, bean);
                log.info("TIANAI-RPC SERVER register[{}]", (Object)interfaceClass.getName());
            });
            this.rpcProviderMap.clear();
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

