/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.demo.example;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.RemotingServerConfiguration;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.remoting.codec.hessian2.Hessian2Decoder;
import cloud.tianai.remoting.codec.hessian2.Hessian2Encoder;
import cloud.tianai.remoting.netty.NettyServer;
import cloud.tianai.rpc.demo.example.Demo;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataDecoder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import java.util.concurrent.CountDownLatch;

public class NettyServerTest {
    public static CountDownLatch countDownLatch = new CountDownLatch(1);

    public static void main(String[] args) throws InterruptedException {
        NettyServer nettyServer = new NettyServer();
        RemotingServerConfiguration config = new RemotingServerConfiguration();
        config.setHost("127.0.0.1");
        config.setPort(Integer.valueOf(20881));
        config.setWorkerThreads(Integer.valueOf(16));
        config.setEncoder((RemotingDataEncoder)new Hessian2Encoder());
        config.setDecoder((RemotingDataDecoder)new Hessian2Decoder());
        config.setRemotingDataProcessor((RemotingDataProcessor)new DemoRemotingDataProcessor());
        config.setIdleTimeout(Integer.valueOf(60000));
        config.setBossThreads(Integer.valueOf(1));
        RemotingChannelHolder channelHolder = nettyServer.start((RemotingConfiguration)config);
        System.out.println("nettyServer\u542f\u52a8\u6210\u529f");
        countDownLatch.await();
    }

    private static class DemoRemotingDataProcessor
    implements RemotingDataProcessor {
        private DemoRemotingDataProcessor() {
        }

        public void readMessage(Channel channel, Object msg, Object extend) {
            Request request = (Request)msg;
            System.out.println("Server\u7aef\u6536\u5230\u6d88\u606f:" + msg);
            Response response = new Response(Long.valueOf(request.getId()), "v1");
            response.setResult((Object)new Demo(2, "hello\u5ba2\u6237\u7aef"));
            channel.write((Object)response);
        }

        public Object writeMessage(Channel channel, Object msg, Object extend) {
            return null;
        }

        public void sendHeartbeat(Channel channel, Object extend) {
        }

        public void sendError(Channel channel, Throwable ex, Object data) {
        }

        public boolean support(Object msg) {
            return false;
        }
    }
}

