/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.demo.example;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.DefaultFuture;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.RemotingServerConfiguration;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.remoting.codec.hessian2.Hessian2Decoder;
import cloud.tianai.remoting.codec.hessian2.Hessian2Encoder;
import cloud.tianai.remoting.netty.NettyClient;
import cloud.tianai.rpc.demo.example.Demo;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataDecoder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NettyClientTest {
    public static void main(String[] args) throws InterruptedException, ExecutionException, TimeoutException {
        NettyClient nettyClient = new NettyClient();
        RemotingServerConfiguration config = new RemotingServerConfiguration();
        config.setHost("127.0.0.1");
        config.setPort(Integer.valueOf(20881));
        config.setWorkerThreads(Integer.valueOf(16));
        config.setEncoder((RemotingDataEncoder)new Hessian2Encoder());
        config.setDecoder((RemotingDataDecoder)new Hessian2Decoder());
        config.setRemotingDataProcessor((RemotingDataProcessor)new DemoRemotingDataProcessor());
        config.setConnectTimeout(Integer.valueOf(3000));
        RemotingChannelHolder channelHolder = nettyClient.start((RemotingConfiguration)config);
        Demo demo = new Demo(1, "\u54c8\u54c8");
        Request request = new Request();
        CompletableFuture future = channelHolder.request(request, 3000);
        Object res = future.get(3000L, TimeUnit.SECONDS);
        System.out.println("res" + res);
    }

    private static class DemoRemotingDataProcessor
    implements RemotingDataProcessor {
        private DemoRemotingDataProcessor() {
        }

        public void readMessage(Channel channel, Object msg, Object extend) {
            DefaultFuture.received((Channel)channel, (Response)((Response)msg), (boolean)true);
        }

        public Object writeMessage(Channel channel, Object msg, Object extend) {
            return null;
        }

        public void sendHeartbeat(Channel channel, Object extend) {
        }

        public boolean support(Object msg) {
            return true;
        }
    }
}

