/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.util;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.core.bootstrap.Bootstrap;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.holder.RpcClientHolder;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.exception.RpcRemotingException;
import java.util.HashMap;
import java.util.Map;

public class RemotingClientUtils {
    public static RemotingClient getRpcClient(URL url, RpcClientConfiguration config) {
        return RpcClientHolder.computeIfAbsent(config.getUrl().getProtocol(), url.getAddress(), (p, a) -> {
            ExtensionLoader extensionLoader;
            RemotingClient c;
            String protocol = config.getUrl().getProtocol();
            if ("tianai-rpc".equals(protocol)) {
                protocol = "netty";
            }
            if ((c = (RemotingClient)(extensionLoader = ExtensionLoader.getExtensionLoader(RemotingClient.class)).createExtension(protocol, false)) == null) {
                throw new RpcRemotingException("\u65e0\u6cd5\u521b\u5efa\u5bf9\u5e94\u7684 \u8fdc\u7a0b\u5ba2\u6237\u7aef \uff0c client=" + protocol);
            }
            HashMap parameters = new HashMap(config.getUrl().getParameters());
            Map remotingParam = url.getParameters();
            parameters.putAll(remotingParam);
            c.start(url, Bootstrap.simpleRequestResponseRemotingDataProcessor(), parameters);
            return c;
        });
    }
}

