/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.lock.RpcLock;
import cloud.tianai.rpc.common.lock.RpcSpinLock;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.template.RpcClientTemplate;
import cloud.tianai.rpc.core.util.RemotingClientUtils;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.Request;
import cloud.tianai.rpc.remoting.api.Response;
import cloud.tianai.rpc.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.remoting.api.exception.RpcChannelClosedException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcClientTemplate
implements RpcClientTemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcClientTemplate.class);
    private final RpcLock lock = new RpcSpinLock();
    private final Set<RpcClientPostProcessor> rpcClientPostProcessors = new HashSet<RpcClientPostProcessor>(8);

    @Override
    public Response request(Request request, Integer timeout, Integer retry) throws TimeoutException {
        return this.request(request, timeout, retry, retry);
    }

    @Override
    public Response request(Request request, Integer timeout, Integer connectRetry, Integer requestRetry) throws TimeoutException {
        Response response = this.retryRequest(request, 0, connectRetry, requestRetry);
        return response;
    }

    protected void requestFinished(Request request, Response response, RemotingClient remotingClient) {
        this.rpcClientPostProcessors.forEach(r -> r.requestFinished(request, response, remotingClient));
    }

    protected void beforeRequest(Request request, RemotingClient remotingClient) {
        this.rpcClientPostProcessors.forEach(r -> r.beforeRequest(request, remotingClient));
    }

    public Response retryRequest(Request request, int currRetry, Integer connectRetry, Integer requestRetry) throws TimeoutException {
        RemotingClient remotingClient = this.selectRemotingClient(request);
        this.beforeRequest(request, remotingClient);
        try {
            Object resObj = this.request(remotingClient, request, connectRetry);
            Response response = this.warpResponseIfNecessary(resObj, request);
            this.requestFinished(request, response, remotingClient);
            return response;
        }
        catch (TimeoutException e) {
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)(++currRetry));
            if (currRetry > requestRetry) {
                throw new TimeoutException("\u8bf7\u6c42\u5931\u8d25\uff0c \u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)currRetry);
            return this.retryRequest(request, currRetry, connectRetry, requestRetry);
        }
    }

    private Response warpResponseIfNecessary(Object resObj, Request request) {
        Response response;
        if (resObj instanceof Response) {
            response = (Response)resObj;
        } else {
            response = new Response(Long.valueOf(request.getId()));
            response.setResult(resObj);
            response.setStatus((byte)20);
        }
        return response;
    }

    private Object request(RemotingClient remotingClient, Request request, Integer connectRetry) throws TimeoutException {
        CompletableFuture future = remotingClient.getChannel().request(request, this.getRequestTimeout().intValue());
        Object resObj = null;
        try {
            resObj = future.get(this.getRequestTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RpcChannelClosedException) {
                this.reconnectIfNecessary(remotingClient, connectRetry);
                if (remotingClient.isActive()) {
                    resObj = this.request(remotingClient, request, connectRetry);
                }
                throw new TimeoutException(e.getCause().getMessage());
            }
            throw new TimeoutException(e.getCause().getMessage());
        }
        return resObj;
    }

    private void reconnectIfNecessary(RemotingClient remotingClient, Integer connectRetry) throws TimeoutException {
        if (!remotingClient.isActive()) {
            this.getClientLock().lock();
            try {
                if (!remotingClient.isActive()) {
                    remotingClient.reconnect(connectRetry.intValue());
                }
            }
            finally {
                this.getClientLock().unlock();
            }
        }
    }

    protected Integer getRequestTimeout() {
        Integer requestTimeout = this.getConfig().getRequestTimeout();
        return requestTimeout == null || requestTimeout < 1 ? 3000 : requestTimeout;
    }

    @Override
    public RpcLock getClientLock() {
        return this.lock;
    }

    @Override
    public void addPostProcessor(RpcClientPostProcessor postProcessor) {
        assert (postProcessor != null);
        this.rpcClientPostProcessors.remove(postProcessor);
        this.rpcClientPostProcessors.add(postProcessor);
    }

    protected RemotingClient createRpcClientIfNecessary(URL url) {
        RpcClientConfiguration config = this.getConfig();
        return RemotingClientUtils.getRpcClient(url, config);
    }

    protected abstract RemotingClient selectRemotingClient(Request var1);
}

