/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.loadbalance.LoadBalance;
import cloud.tianai.rpc.core.template.AbstractRegistryRpcClientTemplate;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.Request;

public abstract class AbstractLoadBalanceRpcClientTemplate
extends AbstractRegistryRpcClientTemplate {
    private LoadBalance loadBalance;

    @Override
    protected RemotingClient selectRemotingClient(Request request) {
        return this.getLoadBalance().select(this.getRemotingClients(), request);
    }

    @Override
    public LoadBalance getLoadBalance() {
        if (this.loadBalance == null) {
            this.initLoadBalance();
        }
        return this.loadBalance;
    }

    protected void initLoadBalance() {
        if (this.loadBalance == null) {
            RpcClientConfiguration config = this.getConfig();
            String loadBalanceName = config.getOrDefault(config.getLoadBalance(), "random");
            this.loadBalance = (LoadBalance)ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(loadBalanceName);
            if (this.loadBalance == null) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8f6e\u8be2\u7b56\u7565, loadBalanceName=" + loadBalanceName);
            }
        }
    }
}

