/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.loadbalance.impl;

import cloud.tianai.rpc.core.loadbalance.AbstractLoadBalance;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.Request;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "roundrobin";
    private static final int RECYCLE_PERIOD = 60000;
    private ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> methodWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected RemotingClient doSelect(List<RemotingClient> rpcClients, Request request) {
        String key = request.getInterfaceType().getName() + "." + request.getMethodName();
        ConcurrentMap map = this.methodWeightMap.computeIfAbsent(key, k -> new ConcurrentHashMap());
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        RemotingClient selectedRpcClient = null;
        WeightedRoundRobin selectedWrr = null;
        for (RemotingClient rpcClient : rpcClients) {
            WeightedRoundRobin weightedRoundRobin;
            String id = rpcClient.getId();
            int weight = this.getWeight(rpcClient);
            if (weight != (weightedRoundRobin = map.computeIfAbsent(id, k -> {
                WeightedRoundRobin wrr = new WeightedRoundRobin();
                wrr.setWeight(weight);
                return wrr;
            })).getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedRpcClient = rpcClient;
                selectedWrr = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (rpcClients.size() != map.size()) {
            map.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 60000L);
        }
        if (selectedRpcClient != null) {
            selectedWrr.sel(totalWeight);
            return selectedRpcClient;
        }
        return rpcClients.get(0);
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        public long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        public void sel(int total) {
            this.current.addAndGet(-1 * total);
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

