/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.loadbalance.impl;

import cloud.tianai.rpc.core.loadbalance.AbstractLoadBalance;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.Request;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RandomLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "random";

    @Override
    protected RemotingClient doSelect(List<RemotingClient> rpcClients, Request request) {
        int firstWeight;
        int size = rpcClients.size();
        int[] weights = new int[size];
        weights[0] = firstWeight = this.getWeight(rpcClients.get(0));
        boolean sameWeight = true;
        int totalWeight = firstWeight;
        for (int i = 1; i < size; ++i) {
            int weight;
            weights[i] = weight = this.getWeight(rpcClients.get(i));
            totalWeight += weight;
            if (!sameWeight || weight == firstWeight) continue;
            sameWeight = false;
        }
        if (totalWeight != 0 && !sameWeight) {
            int offset = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < size; ++i) {
                if ((offset -= weights[i]) >= 0) continue;
                return rpcClients.get(i);
            }
        }
        return rpcClients.get(ThreadLocalRandom.current().nextInt(size));
    }

    @Override
    public String getName() {
        return NAME;
    }
}

