/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.rpc.remoting.api.RemotingServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class RpcServerHolder {
    private static final String SPLIT = ":";
    private static Map<String, RemotingServer> rpcServerMap = new ConcurrentHashMap<String, RemotingServer>(32);

    public static RemotingServer getRpcServer(String protocol, String address) {
        return rpcServerMap.get(RpcServerHolder.getKey(protocol, address));
    }

    private static String getKey(String protocol, String address) {
        return protocol.concat(SPLIT).concat(address);
    }

    public static RemotingServer computeIfAbsent(String protocol, String address, BiFunction<String, String, RemotingServer> supplier) {
        String key = RpcServerHolder.getKey(protocol, address);
        RemotingServer rpcServer = rpcServerMap.computeIfAbsent(key, k -> (RemotingServer)supplier.apply(protocol, address));
        return rpcServer;
    }

    public static void putRpcServer(String protocol, String address, RemotingServer rpcServer) {
        String key = RpcServerHolder.getKey(protocol, address);
        RemotingServer oldRpcServer = rpcServerMap.remove(key);
        rpcServerMap.put(key, rpcServer);
        if (oldRpcServer != null) {
            oldRpcServer.destroy();
        }
    }

    public static void removeRpcServer(String protocol, String address) {
        String key = RpcServerHolder.getKey(protocol, address);
        RemotingServer rpcServer = rpcServerMap.remove(key);
        if (rpcServer != null) {
            rpcServer.destroy();
        }
    }

    public static void removeRpcServer(String key) {
        RemotingServer rpcServer = rpcServerMap.remove(key);
        if (rpcServer != null) {
            rpcServer.destroy();
        }
    }

    public static void shutdown() {
        for (String key : rpcServerMap.keySet()) {
            RpcServerHolder.removeRpcServer(key);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RpcServerHolder::shutdown));
    }
}

