/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.rpc.remoting.api.RemotingClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class RpcClientHolder {
    private static final String SPLIT = ":";
    private static Map<String, RemotingClient> rpcClientMap = new ConcurrentHashMap<String, RemotingClient>(32);

    public static RemotingClient getRpcClient(String protocol, String address) {
        return rpcClientMap.get(RpcClientHolder.getKey(protocol, address));
    }

    public static RemotingClient computeIfAbsent(String protocol, String address, BiFunction<String, String, RemotingClient> supplier) {
        String key = RpcClientHolder.getKey(protocol, address);
        RemotingClient rpcClient = rpcClientMap.computeIfAbsent(key, k -> (RemotingClient)supplier.apply(protocol, address));
        return rpcClient;
    }

    public static void removeRpcClient(String key) {
        RemotingClient rpcClient = rpcClientMap.remove(key);
        if (rpcClient != null) {
            rpcClient.destroy();
        }
    }

    public static String getKey(String protocol, String address) {
        return protocol.concat(SPLIT).concat(address);
    }

    public static void shutdown() {
        for (String key : rpcClientMap.keySet()) {
            RpcClientHolder.removeRpcClient(key);
        }
    }

    public static void removeRpcClient(String protocol, String address) {
        String key = RpcClientHolder.getKey(protocol, address);
        RpcClientHolder.removeRpcClient(key);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RpcClientHolder::shutdown));
    }
}

