/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.registory.api.Registry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RegistryHolder {
    private static Map<String, Registry> registryCache = new ConcurrentHashMap<String, Registry>(2);

    public static Registry getRegistry(URL url) {
        String key = RegistryHolder.getKey(url);
        return registryCache.get(key);
    }

    public static Registry getRegistry(String key) {
        return registryCache.get(key);
    }

    public static Registry computeIfAbsent(URL url, Function<URL, Registry> supplier) {
        String key = RegistryHolder.getKey(url);
        Registry registry = registryCache.computeIfAbsent(key, k -> (Registry)supplier.apply(url));
        return registry;
    }

    public static void remove(String key) {
        Registry registry = registryCache.remove(key);
        if (registry != null) {
            registry.destroy();
        }
    }

    public static void remove(URL url) {
        String key = RegistryHolder.getKey(url);
        Registry registry = registryCache.remove(key);
        if (registry != null) {
            registry.destroy();
        }
    }

    public static void shutdown() {
        for (String key : registryCache.keySet()) {
            RegistryHolder.remove(key);
        }
    }

    private static String getKey(URL url) {
        return url.toString();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RegistryHolder::shutdown));
    }
}

