/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.context;

import cloud.tianai.rpc.common.URL;
import java.util.HashMap;
import java.util.Map;

public class RpcContext {
    private static final ThreadLocal<RpcContext> LOCAL = ThreadLocal.withInitial(RpcContext::new);
    private final Map<String, Object> attachments = new HashMap<String, Object>();
    private Object request;
    private Object response;
    private URL remotingUrl;

    public static RpcContext getRpcContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public RpcContext setAttachments(Map<String, Object> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public RpcContext removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    public RpcContext setAttachment(String key, Object value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    public Object getAttachment(String key) {
        return this.attachments.get(key);
    }

    public RpcContext setRequest(Object request) {
        this.request = request;
        return this;
    }

    public RpcContext setResponse(Object response) {
        this.response = response;
        return this;
    }

    public RpcContext setRemotingUrl(URL remotingUrl) {
        this.remotingUrl = remotingUrl;
        return this;
    }

    public URL getRemotingUrl() {
        return this.remotingUrl;
    }

    public Object getRequest() {
        return this.request;
    }

    public Object getResponse() {
        return this.response;
    }
}

