/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.configuration;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.sort.OrderComparator;
import cloud.tianai.rpc.core.context.RpcContextClientPostProcessor;
import cloud.tianai.rpc.remoting.api.RpcClientPostProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RpcClientConfiguration {
    private static final List<RpcClientPostProcessor> RPC_CLIENT_POST_PROCESSORS = new LinkedList<RpcClientPostProcessor>();
    private String loadBalance;
    private Integer requestTimeout = 3000;
    private Integer retry = 3;
    private URL registryUrl;
    private URL url = new URL();
    private Integer timeout = 5000;
    private boolean lazyLoadRegistry = true;
    private boolean lazyStartRpcClient = true;
    private List<RpcClientPostProcessor> rpcClientPostProcessors = new LinkedList<RpcClientPostProcessor>();

    public void addRpcClientPostProcessor(RpcClientPostProcessor postProcessor) {
        assert (postProcessor != null);
        this.removeRpcClientPostProcessor(postProcessor);
        this.rpcClientPostProcessors.add(postProcessor);
    }

    public List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        ArrayList<RpcClientPostProcessor> result = new ArrayList<RpcClientPostProcessor>(this.getRpcClientPostProcessorCount());
        result.addAll(RPC_CLIENT_POST_PROCESSORS);
        result.addAll(this.rpcClientPostProcessors);
        result.sort((Comparator<RpcClientPostProcessor>)OrderComparator.INSTANCE);
        return result;
    }

    public boolean removeRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        if (!this.rpcClientPostProcessors.remove(rpcClientPostProcessor)) {
            return RpcClientConfiguration.removeCommonRpcClientPostProcessor(rpcClientPostProcessor);
        }
        return true;
    }

    public int getRpcClientPostProcessorCount() {
        return RPC_CLIENT_POST_PROCESSORS.size() + this.rpcClientPostProcessors.size();
    }

    public static boolean removeCommonRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        return RPC_CLIENT_POST_PROCESSORS.remove(rpcClientPostProcessor);
    }

    public static void addCommonRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        assert (rpcClientPostProcessor != null);
        RpcClientConfiguration.removeCommonRpcClientPostProcessor(rpcClientPostProcessor);
        RPC_CLIENT_POST_PROCESSORS.add(rpcClientPostProcessor);
    }

    public <T> T getOrDefault(T val, T defVal) {
        if (val == null) {
            return defVal;
        }
        return val;
    }

    public void setCodec(String codec) {
        this.addParameter("codec", codec);
    }

    public void addParameter(String key, Object value) {
        this.setUrl(this.getUrl().addParameter(key, value));
    }

    public void setProtocol(String protocol) {
        this.getUrl().setProtocol(protocol);
    }

    public String getLoadBalance() {
        return this.loadBalance;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public URL getRegistryUrl() {
        return this.registryUrl;
    }

    public URL getUrl() {
        return this.url;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean isLazyLoadRegistry() {
        return this.lazyLoadRegistry;
    }

    public boolean isLazyStartRpcClient() {
        return this.lazyStartRpcClient;
    }

    public void setLoadBalance(String loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public void setRegistryUrl(URL registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setLazyLoadRegistry(boolean lazyLoadRegistry) {
        this.lazyLoadRegistry = lazyLoadRegistry;
    }

    public void setLazyStartRpcClient(boolean lazyStartRpcClient) {
        this.lazyStartRpcClient = lazyStartRpcClient;
    }

    public void setRpcClientPostProcessors(List<RpcClientPostProcessor> rpcClientPostProcessors) {
        this.rpcClientPostProcessors = rpcClientPostProcessors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcClientConfiguration)) {
            return false;
        }
        RpcClientConfiguration other = (RpcClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$loadBalance = this.getLoadBalance();
        String other$loadBalance = other.getLoadBalance();
        if (this$loadBalance == null ? other$loadBalance != null : !this$loadBalance.equals(other$loadBalance)) {
            return false;
        }
        Integer this$requestTimeout = this.getRequestTimeout();
        Integer other$requestTimeout = other.getRequestTimeout();
        if (this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout)) {
            return false;
        }
        Integer this$retry = this.getRetry();
        Integer other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        URL this$registryUrl = this.getRegistryUrl();
        URL other$registryUrl = other.getRegistryUrl();
        if (this$registryUrl == null ? other$registryUrl != null : !this$registryUrl.equals(other$registryUrl)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        if (this.isLazyLoadRegistry() != other.isLazyLoadRegistry()) {
            return false;
        }
        if (this.isLazyStartRpcClient() != other.isLazyStartRpcClient()) {
            return false;
        }
        List<RpcClientPostProcessor> this$rpcClientPostProcessors = this.getRpcClientPostProcessors();
        List<RpcClientPostProcessor> other$rpcClientPostProcessors = other.getRpcClientPostProcessors();
        return !(this$rpcClientPostProcessors == null ? other$rpcClientPostProcessors != null : !((Object)this$rpcClientPostProcessors).equals(other$rpcClientPostProcessors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loadBalance = this.getLoadBalance();
        result = result * 59 + ($loadBalance == null ? 43 : $loadBalance.hashCode());
        Integer $requestTimeout = this.getRequestTimeout();
        result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
        Integer $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        URL $registryUrl = this.getRegistryUrl();
        result = result * 59 + ($registryUrl == null ? 43 : $registryUrl.hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        result = result * 59 + (this.isLazyLoadRegistry() ? 79 : 97);
        result = result * 59 + (this.isLazyStartRpcClient() ? 79 : 97);
        List<RpcClientPostProcessor> $rpcClientPostProcessors = this.getRpcClientPostProcessors();
        result = result * 59 + ($rpcClientPostProcessors == null ? 43 : ((Object)$rpcClientPostProcessors).hashCode());
        return result;
    }

    public String toString() {
        return "RpcClientConfiguration(loadBalance=" + this.getLoadBalance() + ", requestTimeout=" + this.getRequestTimeout() + ", retry=" + this.getRetry() + ", registryUrl=" + this.getRegistryUrl() + ", url=" + this.getUrl() + ", timeout=" + this.getTimeout() + ", lazyLoadRegistry=" + this.isLazyLoadRegistry() + ", lazyStartRpcClient=" + this.isLazyStartRpcClient() + ", rpcClientPostProcessors=" + this.getRpcClientPostProcessors() + ")";
    }

    static {
        RpcClientConfiguration.addCommonRpcClientPostProcessor(new RpcContextClientPostProcessor());
    }
}

