/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.client.proxy;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.util.IPUtils;
import cloud.tianai.rpc.core.client.proxy.RpcProxy;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.template.DefaultRpcClientTemplate;
import cloud.tianai.rpc.core.template.RpcClientTemplate;
import cloud.tianai.rpc.remoting.api.Request;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcProxy<T>
implements RpcProxy<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcProxy.class);
    public static final String TO_STRING_FUN_NAME = "toString";
    public static final String HASH_CODE_FUN_NAME = "hashCode";
    public static final String EQUALS_FUN_NAME = "equals";
    protected Class<T> interfaceClass;
    protected URL url;
    protected Integer requestTimeout;
    protected RpcClientConfiguration rpcConfiguration;
    protected int retry;
    protected RpcClientTemplate rpcClientTemplate;

    @Override
    public T createProxy(Class<T> interfaceClass, RpcClientConfiguration conf) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("\u521b\u5efarpc\u4ee3\u7406\u9519\u8bef\uff0cclass\u5fc5\u987b\u662f\u63a5\u53e3");
        }
        this.rpcConfiguration = conf;
        this.interfaceClass = interfaceClass;
        this.requestTimeout = conf.getOrDefault(conf.getRequestTimeout(), 5000);
        this.retry = conf.getOrDefault(conf.getRetry(), 3);
        this.url = new URL("tianai-rpc", IPUtils.getHostIp(), 0, interfaceClass.getName());
        this.rpcClientTemplate = this.createRpcClientTemplate(conf, conf.isLazyLoadRegistry(), conf.isLazyStartRpcClient());
        return this.doCreateProxy();
    }

    private RpcClientTemplate createRpcClientTemplate(RpcClientConfiguration conf, boolean lazyLoadRegistry, boolean lazyStartRpcClient) {
        return new DefaultRpcClientTemplate(conf, this.url, lazyLoadRegistry, lazyStartRpcClient, true);
    }

    protected abstract T doCreateProxy();

    protected Request warpRequest(Object proxy, Method method, Object[] args) {
        Request request = new Request();
        request.setVersion("v1").setRequestParam(args).setMethodName(method.getName()).setInterfaceType(this.interfaceClass).setReturnType(method.getReturnType()).setHeartbeat(false);
        return request;
    }

    public String toString() {
        return "tianai-rpc-proxy{interfaceClass=" + this.interfaceClass + ", url=" + this.url + ", requestTimeout=" + this.requestTimeout + ", rpcConfiguration=" + this.rpcConfiguration + ", retry=" + this.retry + ", rpcClientTemplate=" + this.rpcClientTemplate + '}';
    }

    public RpcClientTemplate getRpcClientTemplate() {
        return this.rpcClientTemplate;
    }
}

