/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.bootstrap;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.constant.CommonConstant;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.common.util.IPUtils;
import cloud.tianai.rpc.core.holder.RegistryHolder;
import cloud.tianai.rpc.core.holder.RpcServerHolder;
import cloud.tianai.rpc.core.util.RegistryUtils;
import cloud.tianai.rpc.registory.api.Registry;
import cloud.tianai.rpc.registory.api.exception.RpcRegistryException;
import cloud.tianai.rpc.remoting.api.DefaultRpcInvocation;
import cloud.tianai.rpc.remoting.api.RemotingChannelHolder;
import cloud.tianai.rpc.remoting.api.RemotingDataProcessor;
import cloud.tianai.rpc.remoting.api.RemotingServer;
import cloud.tianai.rpc.remoting.api.RequestResponseRemotingDataProcessor;
import cloud.tianai.rpc.remoting.api.RpcInvocation;
import cloud.tianai.rpc.remoting.api.RpcInvocationPostProcessor;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ServerBootstrap.class);
    private URL serverURL = new URL("tianai-rpc", IPUtils.getHostIp(), 20881);
    private Map<String, Object> parameters = new HashMap<String, Object>(16);
    private URL registryURL;
    private List<RpcInvocationPostProcessor> postProcessors = new LinkedList<RpcInvocationPostProcessor>();
    private RemotingServer remotingServer;
    private Registry registry;
    private AtomicBoolean start = new AtomicBoolean(false);
    private DefaultRpcInvocation rpcInvocation = new DefaultRpcInvocation();
    Map<URL, Object> temporaryObjectMap = new ConcurrentHashMap<URL, Object>(256);

    public ServerBootstrap protocol(String protocol) {
        this.serverURL.setProtocol(protocol);
        return this;
    }

    public ServerBootstrap host(String host) {
        this.serverURL.setHost(host);
        return this;
    }

    public ServerBootstrap port(Integer port) {
        this.serverURL.setPort(port.intValue());
        return this;
    }

    public ServerBootstrap address(InetSocketAddress address) {
        String host = address.getHostString();
        int port = address.getPort();
        return this.host(host).port(port);
    }

    public ServerBootstrap codec(String codec) {
        this.parameters.put("codec", codec);
        return this;
    }

    public ServerBootstrap registry(URL registryConfig) {
        this.registryURL = registryConfig;
        return this;
    }

    public ServerBootstrap workThreads(Integer threads) {
        this.parameters.put("workerThreads", threads);
        return this;
    }

    public ServerBootstrap bossThreads(Integer threads) {
        this.parameters.put("bossThreads", threads);
        return this;
    }

    public ServerBootstrap timeout(Integer timeout) {
        this.parameters.put("timeout", timeout);
        return this;
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            throw new RpcException("\u8be5\u670d\u52a1\u5df2\u7ecf\u542f\u52a8\uff0c\u8bf7\u52ff\u91cd\u590d\u542f\u52a8[host=" + this.getServerURL().getHost() + ", port=" + this.getServerURL().getPort() + "]");
        }
        this.setDefaultParamsIfAbsent(this.parameters);
        this.parameters.putIfAbsent("weight", CommonConstant.DEFAULT_WEIGHT);
        this.serverURL.setParameters(CollectionUtils.toStringValueMap(this.parameters));
        this.startRemotingServer();
        this.startRegistry();
        this.temporaryObjectMap = Collections.unmodifiableMap(this.temporaryObjectMap);
        if (this.temporaryObjectMap.size() > 0) {
            this.temporaryObjectMap.forEach(this::register);
        }
    }

    private void setDefaultParamsIfAbsent(Map<String, Object> param) {
        param.putIfAbsent("timeout", 5000);
        param.putIfAbsent("codec", "hessian2");
        param.putIfAbsent("workerThreads", CommonConstant.DEFAULT_IO_THREADS);
        param.putIfAbsent("bossThreads", 1);
        param.putIfAbsent("idleTimeout", 600000);
    }

    public RemotingChannelHolder getChannel() {
        if (this.remotingServer == null) {
            return null;
        }
        return this.remotingServer.getChannel();
    }

    public ServerBootstrap register(Class<?> interfaceClazz, Object ref) {
        this.register(interfaceClazz, ref, null);
        return this;
    }

    public ServerBootstrap register(Class<?> interfaceClazz, Object ref, Map<String, Object> parameters) {
        parameters = parameters != null && !parameters.isEmpty() ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>(8);
        parameters.putIfAbsent("weight", CommonConstant.DEFAULT_WEIGHT);
        parameters.putIfAbsent("connectTimeout", 600000);
        URL url = new URL("tianai-rpc", this.getServerURL().getHost(), this.getServerURL().getPort(), interfaceClazz.getName(), CollectionUtils.toStringValueMap(parameters));
        if (!this.isStart()) {
            this.temporaryObjectMap.put(url, ref);
            return this;
        }
        this.registry.register(url);
        this.rpcInvocation.putInvokeObj(interfaceClazz, ref);
        return this;
    }

    public ServerBootstrap register(URL url, Object ref) {
        Class interfaceClazz;
        if (!this.isStart()) {
            this.temporaryObjectMap.put(url, ref);
            return this;
        }
        try {
            interfaceClazz = ClassUtils.forName((String)url.getPath());
        }
        catch (ClassNotFoundException e) {
            throw new RpcRegistryException("\u6ce8\u518c\u5730\u5740\u5931\u8d25\uff0c path\u6307\u5b9a\u7684\u503c\u5fc5\u987b\u662fclass\u7c7b\u578b\uff0c\u4e14\u53ef\u88ab\u627e\u5230, path=" + url.getPath(), (Throwable)e);
        }
        this.registry.register(url);
        this.rpcInvocation.putInvokeObj(interfaceClazz, ref);
        return this;
    }

    public boolean isStart() {
        return this.start.get();
    }

    public String getServerAddress() {
        String host = this.getServerURL().getHost();
        Integer port = this.getServerURL().getPort();
        if (host == null) {
            host = IPUtils.getHostIp();
        }
        if (port < 0) {
            return host;
        }
        assert (host != null);
        return host.concat(":").concat(String.valueOf(port));
    }

    private void startRemotingServer() {
        this.remotingServer = RpcServerHolder.computeIfAbsent(this.getServerURL().getProtocol(), this.getServerAddress(), (s, a) -> {
            RemotingServer r = (RemotingServer)ExtensionLoader.getExtensionLoader(RemotingServer.class).createExtension(s, false);
            if (Objects.isNull(r)) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdc\u7a0bserver, server=" + s);
            }
            if (CollectionUtils.isNotEmpty(this.postProcessors)) {
                this.postProcessors.forEach(arg_0 -> ((DefaultRpcInvocation)this.rpcInvocation).addPostProcessor(arg_0));
            }
            RequestResponseRemotingDataProcessor remotingDataProcessor = new RequestResponseRemotingDataProcessor((RpcInvocation)this.rpcInvocation);
            r.start(this.getServerURL(), (RemotingDataProcessor)remotingDataProcessor, this.getServerURL().getParameters());
            return r;
        });
    }

    private void startRegistry() {
        this.registry = RegistryHolder.computeIfAbsent(this.getRegistryURL(), RegistryUtils::createAndStart);
    }

    public void shutdown() {
        if (this.start.compareAndSet(true, false)) {
            if (this.remotingServer != null) {
                this.remotingServer.destroy();
            }
            if (this.registry != null) {
                this.registry.destroy();
            }
        }
    }

    public void addRpcInvocationPostProcessor(RpcInvocationPostProcessor rpcInvocationPostProcessor) {
        this.postProcessors.remove(rpcInvocationPostProcessor);
        this.postProcessors.add(rpcInvocationPostProcessor);
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(URL serverURL) {
        this.serverURL = serverURL;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public URL getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(URL registryURL) {
        this.registryURL = registryURL;
    }

    public List<RpcInvocationPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<RpcInvocationPostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

