/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.bootstrap;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.core.holder.RpcClientHolder;
import cloud.tianai.rpc.remoting.api.RemotingClient;
import cloud.tianai.rpc.remoting.api.RemotingConfiguration;
import cloud.tianai.rpc.remoting.api.RemotingDataProcessor;
import cloud.tianai.rpc.remoting.api.RequestResponseRemotingDataProcessor;
import cloud.tianai.rpc.remoting.api.RpcInvocation;
import cloud.tianai.rpc.remoting.api.SimpleHeartbeatRpcInvocation;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class Bootstrap {
    private AtomicBoolean start = new AtomicBoolean(false);
    private RemotingClient remotingClient;
    private String protocol = "netty";
    private URL url;
    private RemotingConfiguration conf = new RemotingConfiguration();
    private String client = "netty";
    private String codec = "hessian2";

    public static RemotingDataProcessor simpleRequestResponseRemotingDataProcessor() {
        return SimpleRequestResponseRemotingDataProcessor.INSTANCE;
    }

    public Bootstrap codec(String codec) {
        this.codec = codec;
        return this;
    }

    private Bootstrap timeout(Integer timeout) {
        this.conf.setConnectTimeout(timeout);
        return this;
    }

    public Bootstrap client(String client) {
        this.client = client;
        return this;
    }

    public RemotingClient start(URL url) throws RpcException {
        if (this.start.compareAndSet(false, true)) {
            try {
                this.url = url;
                this.startRemotingClient();
            }
            finally {
                this.start.set(false);
            }
        }
        return this.remotingClient;
    }

    private void startRemotingClient() {
        this.remotingClient = RpcClientHolder.computeIfAbsent(this.protocol, this.url.getAddress(), (p, u) -> {
            RemotingClient r = (RemotingClient)ExtensionLoader.getExtensionLoader(RemotingClient.class).createExtension(this.protocol, false);
            if (Objects.isNull(r)) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdc\u7a0bserver, protocol=" + this.protocol);
            }
            r.start(this.url, Bootstrap.simpleRequestResponseRemotingDataProcessor(), this.url.getParameters());
            return r;
        });
    }

    public void shutdown() {
        if (this.start.compareAndSet(true, false) && this.remotingClient != null) {
            this.remotingClient.destroy();
        }
    }

    public boolean isStart() {
        return this.start.get();
    }

    public RemotingConfiguration getConf() {
        return this.conf;
    }

    public static class SimpleRequestResponseRemotingDataProcessor {
        public static final RemotingDataProcessor INSTANCE = new RequestResponseRemotingDataProcessor((RpcInvocation)new SimpleHeartbeatRpcInvocation());
    }
}

