/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.configuration;

import cloud.tianai.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.common.configuration.RpcConfiguration;
import cloud.tianai.rpc.common.sort.OrderComparator;
import cloud.tianai.rpc.core.context.RpcContextClientPostProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RpcClientConfiguration
extends RpcConfiguration {
    private static final List<RpcClientPostProcessor> commonRpcClientPostProcessors = new LinkedList<RpcClientPostProcessor>();
    private String loadBalance;
    private Integer requestTimeout = 3000;
    private Integer retry = 3;
    private boolean lazyLoadRegistry = true;
    private boolean lazyStartRpcClient = true;
    private List<RpcClientPostProcessor> rpcClientPostProcessors = new LinkedList<RpcClientPostProcessor>();

    public void addRpcClientPostProcessor(RpcClientPostProcessor postProcessor) {
        assert (postProcessor != null);
        this.removeRpcClientPostProcessor(postProcessor);
        this.rpcClientPostProcessors.add(postProcessor);
    }

    public List<RpcClientPostProcessor> getRpcClientPostProcessors() {
        ArrayList<RpcClientPostProcessor> result = new ArrayList<RpcClientPostProcessor>(this.getRpcClientPostProcessorCount());
        result.addAll(commonRpcClientPostProcessors);
        result.addAll(this.rpcClientPostProcessors);
        result.sort((Comparator<RpcClientPostProcessor>)OrderComparator.INSTANCE);
        return result;
    }

    public boolean removeRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        if (!this.rpcClientPostProcessors.remove(rpcClientPostProcessor)) {
            return RpcClientConfiguration.removeCommonRpcClientPostProcessor(rpcClientPostProcessor);
        }
        return true;
    }

    public int getRpcClientPostProcessorCount() {
        return commonRpcClientPostProcessors.size() + this.rpcClientPostProcessors.size();
    }

    public static boolean removeCommonRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        return commonRpcClientPostProcessors.remove(rpcClientPostProcessor);
    }

    public static void addCommonRpcClientPostProcessor(RpcClientPostProcessor rpcClientPostProcessor) {
        assert (rpcClientPostProcessor != null);
        RpcClientConfiguration.removeCommonRpcClientPostProcessor(rpcClientPostProcessor);
        commonRpcClientPostProcessors.add(rpcClientPostProcessor);
    }

    public String getLoadBalance() {
        return this.loadBalance;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public boolean isLazyLoadRegistry() {
        return this.lazyLoadRegistry;
    }

    public boolean isLazyStartRpcClient() {
        return this.lazyStartRpcClient;
    }

    public void setLoadBalance(String loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public void setLazyLoadRegistry(boolean lazyLoadRegistry) {
        this.lazyLoadRegistry = lazyLoadRegistry;
    }

    public void setLazyStartRpcClient(boolean lazyStartRpcClient) {
        this.lazyStartRpcClient = lazyStartRpcClient;
    }

    public void setRpcClientPostProcessors(List<RpcClientPostProcessor> rpcClientPostProcessors) {
        this.rpcClientPostProcessors = rpcClientPostProcessors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcClientConfiguration)) {
            return false;
        }
        RpcClientConfiguration other = (RpcClientConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$loadBalance = this.getLoadBalance();
        String other$loadBalance = other.getLoadBalance();
        if (this$loadBalance == null ? other$loadBalance != null : !this$loadBalance.equals(other$loadBalance)) {
            return false;
        }
        Integer this$requestTimeout = this.getRequestTimeout();
        Integer other$requestTimeout = other.getRequestTimeout();
        if (this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout)) {
            return false;
        }
        Integer this$retry = this.getRetry();
        Integer other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        if (this.isLazyLoadRegistry() != other.isLazyLoadRegistry()) {
            return false;
        }
        if (this.isLazyStartRpcClient() != other.isLazyStartRpcClient()) {
            return false;
        }
        List<RpcClientPostProcessor> this$rpcClientPostProcessors = this.getRpcClientPostProcessors();
        List<RpcClientPostProcessor> other$rpcClientPostProcessors = other.getRpcClientPostProcessors();
        return !(this$rpcClientPostProcessors == null ? other$rpcClientPostProcessors != null : !((Object)this$rpcClientPostProcessors).equals(other$rpcClientPostProcessors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loadBalance = this.getLoadBalance();
        result = result * 59 + ($loadBalance == null ? 43 : $loadBalance.hashCode());
        Integer $requestTimeout = this.getRequestTimeout();
        result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
        Integer $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        result = result * 59 + (this.isLazyLoadRegistry() ? 79 : 97);
        result = result * 59 + (this.isLazyStartRpcClient() ? 79 : 97);
        List<RpcClientPostProcessor> $rpcClientPostProcessors = this.getRpcClientPostProcessors();
        result = result * 59 + ($rpcClientPostProcessors == null ? 43 : ((Object)$rpcClientPostProcessors).hashCode());
        return result;
    }

    public String toString() {
        return "RpcClientConfiguration(loadBalance=" + this.getLoadBalance() + ", requestTimeout=" + this.getRequestTimeout() + ", retry=" + this.getRetry() + ", lazyLoadRegistry=" + this.isLazyLoadRegistry() + ", lazyStartRpcClient=" + this.isLazyStartRpcClient() + ", rpcClientPostProcessors=" + this.getRpcClientPostProcessors() + ")";
    }

    static {
        RpcClientConfiguration.addCommonRpcClientPostProcessor(new RpcContextClientPostProcessor());
    }
}

