/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.configuration;

import cloud.tianai.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.rpc.common.configuration.RpcConfiguration;
import cloud.tianai.rpc.common.sort.OrderComparator;
import cloud.tianai.rpc.common.util.IPUtils;
import cloud.tianai.rpc.core.context.RpcContextInvocationPostProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RpcServerConfiguration
extends RpcConfiguration {
    private static final List<RpcInvocationPostProcessor> commonInvocationPostProcessors = new LinkedList<RpcInvocationPostProcessor>();
    private String host = IPUtils.getHostIp();
    private Integer port = 20881;
    private Integer bossThreads = 1;
    private Integer idleTimeout;
    private List<RpcInvocationPostProcessor> invocationPostProcessors = new LinkedList<RpcInvocationPostProcessor>();

    public void addRpcInvocationPostProcessor(RpcInvocationPostProcessor rpcInvocationPostProcessor) {
        this.removeInvocationPostProcessor(rpcInvocationPostProcessor);
        this.invocationPostProcessors.add(rpcInvocationPostProcessor);
    }

    public static void addCommonRpcInvocationPostProcessor(RpcInvocationPostProcessor commonRpcInvocationPostProcessor) {
        RpcServerConfiguration.removeCommonRpcInvocationPostProcessor(commonRpcInvocationPostProcessor);
        commonInvocationPostProcessors.add(commonRpcInvocationPostProcessor);
    }

    public static boolean removeCommonRpcInvocationPostProcessor(RpcInvocationPostProcessor commonRpcInvocationPostProcessor) {
        return commonInvocationPostProcessors.remove(commonRpcInvocationPostProcessor);
    }

    public List<RpcInvocationPostProcessor> getInvocationPostProcessors() {
        ArrayList<RpcInvocationPostProcessor> result = new ArrayList<RpcInvocationPostProcessor>(this.getInvocationPostProcessorCount());
        result.addAll(commonInvocationPostProcessors);
        result.addAll(this.invocationPostProcessors);
        result.sort((Comparator<RpcInvocationPostProcessor>)OrderComparator.INSTANCE);
        return result;
    }

    public int getInvocationPostProcessorCount() {
        return this.invocationPostProcessors.size() + commonInvocationPostProcessors.size();
    }

    public boolean removeInvocationPostProcessor(RpcInvocationPostProcessor rpcInvocationPostProcessor) {
        if (!this.invocationPostProcessors.remove(rpcInvocationPostProcessor)) {
            return RpcServerConfiguration.removeCommonRpcInvocationPostProcessor(rpcInvocationPostProcessor);
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getBossThreads() {
        return this.bossThreads;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setBossThreads(Integer bossThreads) {
        this.bossThreads = bossThreads;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setInvocationPostProcessors(List<RpcInvocationPostProcessor> invocationPostProcessors) {
        this.invocationPostProcessors = invocationPostProcessors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpcServerConfiguration)) {
            return false;
        }
        RpcServerConfiguration other = (RpcServerConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$bossThreads = this.getBossThreads();
        Integer other$bossThreads = other.getBossThreads();
        if (this$bossThreads == null ? other$bossThreads != null : !((Object)this$bossThreads).equals(other$bossThreads)) {
            return false;
        }
        Integer this$idleTimeout = this.getIdleTimeout();
        Integer other$idleTimeout = other.getIdleTimeout();
        if (this$idleTimeout == null ? other$idleTimeout != null : !((Object)this$idleTimeout).equals(other$idleTimeout)) {
            return false;
        }
        List<RpcInvocationPostProcessor> this$invocationPostProcessors = this.getInvocationPostProcessors();
        List<RpcInvocationPostProcessor> other$invocationPostProcessors = other.getInvocationPostProcessors();
        return !(this$invocationPostProcessors == null ? other$invocationPostProcessors != null : !((Object)this$invocationPostProcessors).equals(other$invocationPostProcessors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpcServerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $bossThreads = this.getBossThreads();
        result = result * 59 + ($bossThreads == null ? 43 : ((Object)$bossThreads).hashCode());
        Integer $idleTimeout = this.getIdleTimeout();
        result = result * 59 + ($idleTimeout == null ? 43 : ((Object)$idleTimeout).hashCode());
        List<RpcInvocationPostProcessor> $invocationPostProcessors = this.getInvocationPostProcessors();
        result = result * 59 + ($invocationPostProcessors == null ? 43 : ((Object)$invocationPostProcessors).hashCode());
        return result;
    }

    public String toString() {
        return "RpcServerConfiguration(host=" + this.getHost() + ", port=" + this.getPort() + ", bossThreads=" + this.getBossThreads() + ", idleTimeout=" + this.getIdleTimeout() + ", invocationPostProcessors=" + this.getInvocationPostProcessors() + ")";
    }

    static {
        RpcServerConfiguration.addCommonRpcInvocationPostProcessor(new RpcContextInvocationPostProcessor());
    }
}

