/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.util;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.RequestResponseRemotingDataProcessor;
import cloud.tianai.remoting.api.RpcInvocation;
import cloud.tianai.remoting.api.exception.RpcRemotingException;
import cloud.tianai.rpc.common.KeyValue;
import cloud.tianai.rpc.common.RpcClientConfiguration;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.constant.CommonConstant;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.client.proxy.AbstractRpcProxy;
import cloud.tianai.rpc.core.factory.CodecFactory;
import cloud.tianai.rpc.core.factory.RemotingClientFactory;
import cloud.tianai.rpc.core.holder.RpcClientHolder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataDecoder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import org.apache.commons.lang3.StringUtils;

public class RemotingClientUtils {
    public static RemotingClient getRpcClient(RpcClientConfiguration rpcConfiguration, URL url) {
        return RpcClientHolder.computeIfAbsent(url.getProtocol(), url.getAddress(), (p, a) -> {
            String host = url.getHost();
            if (StringUtils.isBlank((CharSequence)host)) {
                throw new RpcException("\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u5fc5\u987b\u6307\u5b9ahost");
            }
            Integer port = url.getPort();
            int workThreads = rpcConfiguration.getWorkerThread();
            String codecProtocol = (String)rpcConfiguration.getOrDefault((Object)rpcConfiguration.getCodec(), (Object)"hessian2");
            KeyValue<RemotingDataEncoder, RemotingDataDecoder> codec = CodecFactory.getCodec(codecProtocol);
            if (codec == null || !codec.isNotEmpty()) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684codec\uff0c protocol=" + codecProtocol);
            }
            Integer timeout = (Integer)rpcConfiguration.getOrDefault((Object)rpcConfiguration.getTimeout(), (Object)CommonConstant.DEFAULT_TIMEOUT);
            RemotingConfiguration conf = new RemotingConfiguration();
            conf.setHost(host);
            conf.setPort(port);
            conf.setWorkerThreads(Integer.valueOf(workThreads));
            conf.setEncoder((RemotingDataEncoder)codec.getKey());
            conf.setDecoder((RemotingDataDecoder)codec.getValue());
            conf.setConnectTimeout(timeout);
            conf.setRemotingDataProcessor((RemotingDataProcessor)new RequestResponseRemotingDataProcessor((RpcInvocation)new AbstractRpcProxy.HeartbeatRpcInvocation()));
            String client = rpcConfiguration.getProtocol();
            RemotingClient c = RemotingClientFactory.create(client);
            if (c == null) {
                throw new RpcRemotingException("\u65e0\u6cd5\u521b\u5efa\u5bf9\u5e94\u7684 \u8fdc\u7a0b\u5ba2\u6237\u7aef \uff0c client=" + client);
            }
            c.start(conf);
            return c;
        });
    }
}

