/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.remoting.api.exception.RpcChannelClosedException;
import cloud.tianai.rpc.common.RpcClientConfiguration;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.core.template.RpcClientTemplate;
import cloud.tianai.rpc.core.util.RemotingClientUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcClientTemplate
implements RpcClientTemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcClientTemplate.class);
    private final Object lock = new Object();

    @Override
    public Response request(Request request, Integer timeout, Integer retry) throws TimeoutException {
        return this.request(request, timeout, retry, retry);
    }

    @Override
    public Response request(Request request, Integer timeout, Integer connectRetry, Integer requestRetry) throws TimeoutException {
        Response response;
        Object resObj = this.retryRequest(request, 0, connectRetry, requestRetry);
        if (resObj instanceof Response) {
            response = (Response)resObj;
        } else {
            response = new Response(request.getId());
            response.setResult(resObj);
            response.setStatus((byte)20);
        }
        return response;
    }

    public Object retryRequest(Request request, int currRetry, Integer connectRetry, Integer requestRetry) throws TimeoutException {
        RemotingClient remotingClient = this.selectRemotingClient(request);
        try {
            Object res = this.request(remotingClient, request, connectRetry);
            return res;
        }
        catch (TimeoutException e) {
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)(++currRetry));
            if (currRetry > requestRetry) {
                throw new TimeoutException("\u8bf7\u6c42\u5931\u8d25\uff0c \u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)currRetry);
            return this.retryRequest(request, currRetry, connectRetry, requestRetry);
        }
    }

    private Object request(RemotingClient remotingClient, Request request, Integer connectRetry) throws TimeoutException {
        CompletableFuture future = remotingClient.getChannel().request(request, this.getRequestTimeout().intValue());
        Object resObj = null;
        try {
            resObj = future.get(this.getRequestTimeout().intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RpcChannelClosedException) {
                this.reconnectIfNecessary(remotingClient, connectRetry);
                if (remotingClient.isActive()) {
                    resObj = this.request(remotingClient, request, connectRetry);
                }
                throw new TimeoutException(e.getCause().getMessage());
            }
            throw new TimeoutException(e.getCause().getMessage());
        }
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectIfNecessary(RemotingClient remotingClient, Integer connectRetry) throws TimeoutException {
        if (!remotingClient.isActive()) {
            Object object = this.getClientLock();
            synchronized (object) {
                if (!remotingClient.isActive()) {
                    remotingClient.reconnect(connectRetry.intValue());
                }
            }
        }
    }

    protected Integer getRequestTimeout() {
        Integer requestTimeout = this.getConfig().getRequestTimeout();
        return requestTimeout == null || requestTimeout < 1 ? 3000 : requestTimeout;
    }

    @Override
    public Object getClientLock() {
        return this.lock;
    }

    protected RemotingClient createRpcClientIfNecessary(URL url) {
        RpcClientConfiguration rpcConfiguration = this.getConfig();
        return RemotingClientUtils.getRpcClient(rpcConfiguration, url);
    }

    protected abstract RemotingClient selectRemotingClient(Request var1);
}

