/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.rpc.common.Result;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.holder.RegistryHolder;
import cloud.tianai.rpc.core.template.AbstractRpcClientTemplate;
import cloud.tianai.rpc.core.util.RegistryUtils;
import cloud.tianai.rpc.registory.api.NotifyListener;
import cloud.tianai.rpc.registory.api.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryRpcClientTemplate
extends AbstractRpcClientTemplate
implements NotifyListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractRegistryRpcClientTemplate.class);
    private Registry registry;
    protected volatile List<URL> subscribeUrls = Collections.emptyList();

    @Override
    public List<RemotingClient> getRemotingClients() {
        List<URL> urls = this.lookUpOfThrow();
        ArrayList<RemotingClient> remotingClients = new ArrayList<RemotingClient>(urls.size());
        for (URL url : urls) {
            RemotingClient remotingClient = this.createRpcClientIfNecessary(url);
            remotingClients.add(remotingClient);
        }
        return remotingClients;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.initRegistryIfNecessary();
        }
        return this.registry;
    }

    protected void initRegistryIfNecessary() {
        URL registryUrl = this.getConfig().getRegistryUrl();
        this.registry = RegistryHolder.computeIfAbsent(registryUrl, u -> {
            Registry r1 = RegistryUtils.createAndStart(u);
            r1.subscribe(() -> {
                Object object = this.getClientLock();
                synchronized (object) {
                    this.lookAndSubscribeUrl(this.getUrl());
                }
            });
            return r1;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> lookUpOfThrow() {
        if (CollectionUtils.isEmpty(this.subscribeUrls)) {
            Object object = this.getClientLock();
            synchronized (object) {
                if (CollectionUtils.isEmpty(this.subscribeUrls)) {
                    this.lookAndSubscribeUrl(this.getUrl());
                }
            }
        }
        if (CollectionUtils.isEmpty(this.subscribeUrls)) {
            throw new RpcException("\u6ce8\u518c\u5668\u4e2d\u65e0\u6cd5\u8bfb\u53d6\u5230\u8be5URL [" + this.getUrl() + "] \u5bf9\u5e94\u7684\u6ce8\u518c\u5730\u5740");
        }
        return this.subscribeUrls;
    }

    protected void lookAndSubscribeUrl(URL url) {
        Result lookup = this.getRegistry().lookup(url);
        if (!lookup.isSuccess()) {
            throw new RpcException("\u65e0\u6cd5\u4eceregistry\u4e2d\u62c9\u53d6\u914d\u7f6e\u6d88\u606f, e=" + lookup.getMsg() + ", code=" + lookup.getCode());
        }
        List urls = (List)lookup.getData();
        if (CollectionUtils.isEmpty((Collection)urls)) {
            throw new RpcException("\u65e0\u6cd5\u8bfb\u53d6\u5230\u5bf9\u5e94\u63a5\u53e3\u7684\u6ce8\u518c\u5730\u5740, " + url);
        }
        this.subscribeUrls = urls;
        log.info("TIAN-RPC REGISTRY {}\u62c9\u53d6\u5230\u6d88\u606f:{}", (Object)this.getRegistry().getProtocol(), (Object)urls);
        this.getRegistry().subscribe(url, (NotifyListener)this);
    }

    public void notify(List<URL> urls) {
        log.debug("[registry] \u8ba2\u9605\u5230\u6d88\u606f: {}", urls);
        this.subscribeUrls = urls;
    }
}

