/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.client.proxy.impl;

import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.client.proxy.AbstractRpcProxy;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkRpcProxy<T>
extends AbstractRpcProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(JdkRpcProxy.class);
    public static final String TO_STRING_FUN_NAME = "toString";
    public static final String HASH_CODE_FUN_NAME = "hashCode";
    public static final String EQUALS_FUN_NAME = "equals";

    @Override
    public T doCreateProxy() {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.interfaceClass, Serializable.class}, (InvocationHandler)this);
        return (T)proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Request request;
        Response response;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            if (TO_STRING_FUN_NAME.equals(methodName)) {
                return super.toString();
            }
            if (HASH_CODE_FUN_NAME.equals(methodName)) {
                return super.hashCode();
            }
        } else if (parameterTypes.length == 1 && EQUALS_FUN_NAME.equals(methodName)) {
            return proxy.equals(args[0]);
        }
        if (20 == (response = this.rpcClientTemplate.request(request = this.warpRequest(proxy, method, args), this.requestTimeout, this.retry)).getStatus()) {
            return response.getResult();
        }
        throw new RpcException("rpc\u8bf7\u6c42\u9519\u8bef \uff0c status=" + response.getStatus() + "msg=" + response.getErrorMessage());
    }
}

