/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.exception.RpcChannelClosedException;
import cloud.tianai.rpc.core.util.RpcClientUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientTemplate {
    private static final Logger log = LoggerFactory.getLogger(RpcClientTemplate.class);
    private int requestTimeout;
    private int retry;
    private final Object lockFlag;

    public RpcClientTemplate(int requestTimeout, int retry, Object lockFlag) {
        this.requestTimeout = requestTimeout;
        this.retry = retry;
        this.lockFlag = lockFlag;
    }

    public RpcClientTemplate(int requestTimeout, int retry) {
        this.requestTimeout = requestTimeout;
        this.retry = retry;
        this.lockFlag = new Object();
    }

    public Object request(RemotingClient rpcClient, Request request) throws TimeoutException {
        CompletableFuture future = rpcClient.getchannel().request(request, this.requestTimeout);
        Object resObj = null;
        try {
            resObj = future.get(this.requestTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RpcChannelClosedException) {
                this.reconnectIfNecessary(rpcClient, this.retry);
                if (rpcClient.isActive()) {
                    resObj = this.request(rpcClient, request);
                }
                throw new TimeoutException(e.getCause().getMessage());
            }
            throw new TimeoutException(e.getCause().getMessage());
        }
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectIfNecessary(RemotingClient rpcClient, int retryCount) throws TimeoutException {
        if (!rpcClient.isActive()) {
            Object object = this.lockFlag;
            synchronized (object) {
                if (!rpcClient.isActive()) {
                    RpcClientUtils.reconnect(rpcClient, 0, retryCount);
                }
            }
        }
    }

    public Object retryRequest(RemotingClient rpcClient, Request request, Function<Request, RemotingClient> loadBalance) throws TimeoutException {
        return this.retryRequest(rpcClient, request, 0, loadBalance);
    }

    private Object retryRequest(RemotingClient rpcClient, Request request, int currRetry, Function<Request, RemotingClient> loadBalance) throws TimeoutException {
        try {
            Object res = this.request(rpcClient, request);
            return res;
        }
        catch (TimeoutException e) {
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)(++currRetry));
            if (currRetry > this.retry) {
                throw new TimeoutException("\u8bf7\u6c42\u5931\u8d25\uff0c \u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("\u8bf7\u6c42\u91cd\u8bd5, \u8bf7\u6c42\u4f53 [{}], \u5f53\u524d\u5df2\u91cd\u8bd5\u6b21\u6570{}", (Object)request, (Object)currRetry);
            return this.retryRequest(loadBalance.apply(request), request, currRetry, loadBalance);
        }
    }
}

