/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.loader;

import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.factory.CodecFactory;
import cloud.tianai.rpc.core.factory.RegistryFactory;
import cloud.tianai.rpc.core.factory.RemotingClientFactory;
import cloud.tianai.rpc.core.factory.RemotingServerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcPropertiesLoader {
    private static final Logger log = LoggerFactory.getLogger(RpcPropertiesLoader.class);
    public static final String PROPERTIES_PATH = "META-INF/tianai-rpc.properties";
    public static final String SPLIT = ",";
    private static AtomicBoolean load = new AtomicBoolean(false);
    private static List<URL> loadUrls;
    private static List<Properties> loadProperties;

    public static void loadIfNecessary() {
        if (!load.compareAndSet(false, true)) {
            return;
        }
        Enumeration<URL> resources = null;
        try {
            resources = ClassUtils.getClassLoader().getResources(PROPERTIES_PATH);
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d{}}\u5f02\u5e38e={}", (Object)PROPERTIES_PATH, (Object)e);
            return;
        }
        loadUrls = RpcPropertiesLoader.readUrls(resources);
        loadProperties = RpcPropertiesLoader.converterProperties(loadUrls);
        RpcPropertiesLoader.processRegistry();
        RpcPropertiesLoader.processRemotingServer();
        RpcPropertiesLoader.processRemotingClient();
        RpcPropertiesLoader.processCodec();
    }

    private static void processCodec() {
        RpcPropertiesLoader.processProperties(CodecFactory.class.getName(), 3, datas -> {
            for (Object[] data : datas) {
                try {
                    CodecFactory.registerCodec(data[0], data[1], (String)data[2]);
                }
                catch (ClassNotFoundException e) {
                    log.error("\u52a0\u8f7d \u5e8f\u5217\u5316 \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(data));
                }
            }
        });
    }

    private static void processRemotingClient() {
        RpcPropertiesLoader.processProperties(RemotingClientFactory.class.getName(), 2, datas -> {
            for (Object[] data : datas) {
                try {
                    RemotingClientFactory.addRemotingClient(data[0], data[1]);
                }
                catch (ClassNotFoundException e) {
                    log.error("\u52a0\u8f7d \u8fdc\u7a0bClient \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(data));
                }
            }
        });
    }

    private static void processRemotingServer() {
        RpcPropertiesLoader.processProperties(RemotingServerFactory.class.getName(), 2, datas -> {
            for (Object[] data : datas) {
                try {
                    RemotingServerFactory.addRemotingServer(data[0], data[1]);
                }
                catch (ClassNotFoundException e) {
                    log.error("\u52a0\u8f7d \u8fdc\u7a0bServer \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(data));
                }
            }
        });
    }

    private static void processRegistry() {
        RpcPropertiesLoader.processProperties(RegistryFactory.class.getName(), 2, datas -> {
            for (Object[] data : datas) {
                try {
                    RegistryFactory.addRegistry(data[0], data[1]);
                }
                catch (ClassNotFoundException e) {
                    log.error("\u52a0\u8f7d REGISTRY \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(data));
                }
            }
        });
    }

    private static void processProperties(String name, int splitLen, Consumer<List<String[]>> consumer) {
        LinkedList<String> propData = new LinkedList<String>();
        for (Properties property : loadProperties) {
            String p = property.getProperty(name);
            if (!StringUtils.isNotBlank((CharSequence)p)) continue;
            propData.add(p);
        }
        if (CollectionUtils.isNotEmpty(propData)) {
            ArrayList<String[]> res = new ArrayList<String[]>(propData.size());
            for (String propDatum : propData) {
                String[] split = propDatum.split(SPLIT);
                if (split.length != splitLen) {
                    throw new IllegalStateException("\u89e3\u6790 [tianai-rpc.properties] \u5931\u8d25\uff0c \u5339\u914d\u89c4\u5219\u9519\u8bef\uff0c data=" + propDatum + ", splitLen=" + splitLen + ", splitFlag=" + SPLIT);
                }
                for (int i = 0; i < split.length; ++i) {
                    split[i] = split[i].trim();
                }
                res.add(split);
            }
            consumer.accept(res);
        }
    }

    private static List<Properties> converterProperties(List<URL> readUrls) {
        ArrayList<Properties> properties = new ArrayList<Properties>(readUrls.size());
        for (URL url : readUrls) {
            Properties prop = new Properties();
            try {
                prop.load(url.openStream());
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6tianai-rpc.properties\u5931\u8d25\uff0c path={}, e={}", (Object)url.getPath(), (Object)e);
                continue;
            }
            properties.add(prop);
        }
        return properties;
    }

    private static List<URL> readUrls(Enumeration<URL> resources) {
        if (resources != null && resources.hasMoreElements()) {
            LinkedList<URL> urls = new LinkedList<URL>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                urls.add(url);
            }
            return urls;
        }
        return Collections.emptyList();
    }

    public static boolean isLoad() {
        return load.get();
    }

    public static List<URL> getLoadUrls() {
        return loadUrls;
    }

    public static List<Properties> getLoadProperties() {
        return loadProperties;
    }
}

