/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.remoting.api.RemotingClient;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class RpcClientHolder {
    private static final String SPLIT = ":";
    private static Map<String, RemotingClient> rpcClientMap = new ConcurrentHashMap<String, RemotingClient>(32);
    private static Map<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>(32);

    public static Lock getLock(String protocol, String address) {
        Lock lock = lockMap.computeIfAbsent(RpcClientHolder.getKey(protocol, address), k -> {
            String[] split = k.split(SPLIT);
            Lock l = new Lock(split[0], split[1]);
            return l;
        });
        return lock;
    }

    public static RemotingClient getRpcClient(String protocol, String address) {
        return rpcClientMap.get(RpcClientHolder.getKey(protocol, address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotingClient computeIfAbsent(String protocol, String address, BiFunction<String, String, RemotingClient> supplier) {
        RemotingClient rpcClient = RpcClientHolder.getRpcClient(protocol, address);
        if (rpcClient == null) {
            Lock lock;
            Lock lock2 = lock = RpcClientHolder.getLock(protocol, address);
            synchronized (lock2) {
                rpcClient = RpcClientHolder.getRpcClient(protocol, address);
                if (rpcClient == null) {
                    rpcClient = supplier.apply(protocol, address);
                    RpcClientHolder.putRpcClient(protocol, address, rpcClient);
                }
            }
        }
        return rpcClient;
    }

    public static void putRpcClient(String protocol, String address, RemotingClient rpcClient) {
        String key = RpcClientHolder.getKey(protocol, address);
        RemotingClient oldRpcClient = rpcClientMap.remove(key);
        rpcClientMap.put(key, rpcClient);
        if (oldRpcClient != null) {
            oldRpcClient.stop();
        }
    }

    public static void removeRpcClient(String key) {
        RemotingClient rpcClient = rpcClientMap.remove(key);
        if (rpcClient != null) {
            rpcClient.stop();
        }
    }

    public static String getKey(String protocol, String address) {
        return protocol.concat(SPLIT).concat(address);
    }

    public static void shutdown() {
        for (String key : rpcClientMap.keySet()) {
            RpcClientHolder.removeRpcClient(key);
        }
    }

    public static void removeRpcClient(String protocol, String address) {
        String key = RpcClientHolder.getKey(protocol, address);
        RpcClientHolder.removeRpcClient(key);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RpcClientHolder::shutdown));
    }

    public static class Lock {
        private String protocol;
        private String address;

        public Lock(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Lock lock = (Lock)o;
            return Objects.equals(this.protocol, lock.protocol) && Objects.equals(this.address, lock.address);
        }

        public int hashCode() {
            return Objects.hash(this.protocol, this.address);
        }

        public String toString() {
            return "Lock{protocol='" + this.protocol + '\'' + ", address='" + this.address + '\'' + '}';
        }
    }
}

