/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.registory.api.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class RegistryHolder {
    private static Map<String, Registry> registryCache = new HashMap<String, Registry>(2);
    private static final Object LOCK = new Object();

    public static Registry getRegistry(URL url) {
        String key = RegistryHolder.getKey(url);
        return registryCache.get(key);
    }

    public static Registry getRegistry(String key) {
        return registryCache.get(key);
    }

    public static void putRegistry(URL url, Registry registry) {
        String key = RegistryHolder.getKey(url);
        Registry oldRegistry = registryCache.remove(key);
        registryCache.put(key, registry);
        if (oldRegistry != null) {
            oldRegistry.shutdown();
        }
    }

    public static void putRegistry(String key, Registry registry) {
        Registry oldRegistry = registryCache.remove(key);
        registryCache.put(key, registry);
        if (oldRegistry != null) {
            oldRegistry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry computeIfAbsent(URL url, Function<URL, Registry> supplier) {
        String key = RegistryHolder.getKey(url);
        Registry registry = RegistryHolder.getRegistry(key);
        if (registry == null) {
            Object object = LOCK;
            synchronized (object) {
                registry = RegistryHolder.getRegistry(key);
                if (registry == null) {
                    registry = supplier.apply(url);
                    RegistryHolder.putRegistry(key, registry);
                }
            }
        }
        return registry;
    }

    public static void remove(String key) {
        Registry registry = registryCache.remove(key);
        if (registry != null) {
            registry.shutdown();
        }
    }

    public static void remove(URL url) {
        String key = RegistryHolder.getKey(url);
        Registry registry = registryCache.remove(key);
        if (registry != null) {
            registry.shutdown();
        }
    }

    public static void shutdown() {
        for (String key : registryCache.keySet()) {
            RegistryHolder.remove(key);
        }
    }

    private static String getKey(URL url) {
        return url.toString();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RegistryHolder::shutdown));
    }
}

