/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.util;

import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.factory.RegistryFactory;
import cloud.tianai.rpc.registory.api.Registry;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtils {
    private static final Logger log = LoggerFactory.getLogger(RegistryUtils.class);
    public static final int DEFAULT_RETRY = 3;

    public static Registry createAndStart(URL config) {
        Registry r = RegistryFactory.createRegistry(config.getProtocol());
        Integer retry = config.getParameter("retry", 3);
        Integer index = 0;
        Throwable exception = null;
        while (index <= retry) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            try {
                r.start(config);
            }
            catch (Exception e) {
                exception = e;
                log.error("\u94fe\u63a5registry\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u8fde", (Throwable)e);
            }
            if (r.isStart()) break;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!r.isStart()) {
            if (exception != null) {
                exception.printStackTrace();
                throw new RpcException("\u542f\u52a8registy\u5931\u8d25\uff0ce=" + exception.getLocalizedMessage());
            }
            throw new RpcException("\u542f\u52a8registry\u5931\u8d25.");
        }
        return r;
    }
}

