/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.loadbalance.impl;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.core.loadbalance.LoadBalance;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinLoadBalance
implements LoadBalance {
    public static final String NAME = "roundrobin";
    private static final int RECYCLE_PERIOD = 60000;
    private ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> methodWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>();
    private AtomicBoolean updateLock = new AtomicBoolean();

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemotingClient select(List<RemotingClient> rpcClients, URL url, Request request) {
        if (rpcClients.size() == 1) {
            return rpcClients.get(0);
        }
        String key = request.getInterfaceType().getName() + "." + request.getMethodName();
        ConcurrentMap map = (ConcurrentMap)this.methodWeightMap.get(key);
        if (map == null) {
            this.methodWeightMap.putIfAbsent(key, new ConcurrentHashMap(16));
            map = (ConcurrentMap)this.methodWeightMap.get(key);
        }
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        RemotingClient selectedRpcClient = null;
        WeightedRoundRobin selectedWrr = null;
        for (RemotingClient rpcClient : rpcClients) {
            String id = rpcClient.getId();
            WeightedRoundRobin weightedRoundRobin = (WeightedRoundRobin)map.get(id);
            if (weightedRoundRobin == null) {
                weightedRoundRobin = new WeightedRoundRobin();
                weightedRoundRobin.setWeight(100);
                map.putIfAbsent(id, weightedRoundRobin);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedRpcClient = rpcClient;
                selectedWrr = weightedRoundRobin;
            }
            totalWeight += weightedRoundRobin.getWeight();
        }
        if (!this.updateLock.get() && rpcClients.size() != map.size() && this.updateLock.compareAndSet(false, true)) {
            try {
                ConcurrentHashMap newMap = new ConcurrentHashMap(map);
                newMap.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 60000L);
                this.methodWeightMap.put(key, newMap);
            }
            finally {
                this.updateLock.set(false);
            }
        }
        if (selectedRpcClient != null) {
            selectedWrr.sel(totalWeight);
            return selectedRpcClient;
        }
        return rpcClients.get(0);
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        public long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        public void sel(int total) {
            this.current.addAndGet(-1 * total);
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

