/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.holder;

import cloud.tianai.remoting.api.RemotingServer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class RpcServerHolder {
    private static final String SPLIT = ":";
    private static Map<String, RemotingServer> rpcServerMap = new ConcurrentHashMap<String, RemotingServer>(32);
    private static Map<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>(32);

    public static Lock getLock(String protocol, String address) {
        Lock lock = lockMap.computeIfAbsent(RpcServerHolder.getKey(protocol, address), k -> {
            String[] split = k.split(SPLIT);
            Lock l = new Lock(split[0], split[1]);
            return l;
        });
        return lock;
    }

    public static RemotingServer getRpcServer(String protocol, String address) {
        return rpcServerMap.get(RpcServerHolder.getKey(protocol, address));
    }

    private static String getKey(String protocol, String address) {
        return protocol.concat(SPLIT).concat(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotingServer computeIfAbsent(String protocol, String address, BiFunction<String, String, RemotingServer> supplier) {
        RemotingServer rpcServer = RpcServerHolder.getRpcServer(protocol, address);
        if (rpcServer == null) {
            Lock lock;
            Lock lock2 = lock = RpcServerHolder.getLock(protocol, address);
            synchronized (lock2) {
                rpcServer = RpcServerHolder.getRpcServer(protocol, address);
                if (rpcServer == null) {
                    rpcServer = supplier.apply(protocol, address);
                    RpcServerHolder.putRpcServer(protocol, address, rpcServer);
                }
            }
        }
        return rpcServer;
    }

    public static void putRpcServer(String protocol, String address, RemotingServer rpcServer) {
        String key = RpcServerHolder.getKey(protocol, address);
        RemotingServer oldRpcServer = rpcServerMap.remove(key);
        rpcServerMap.put(key, rpcServer);
        if (oldRpcServer != null) {
            oldRpcServer.stop();
        }
    }

    public static void removeRpcServer(String protocol, String address) {
        String key = RpcServerHolder.getKey(protocol, address);
        RemotingServer rpcServer = rpcServerMap.remove(key);
        if (rpcServer != null) {
            rpcServer.stop();
        }
    }

    public static void removeRpcServer(String key) {
        RemotingServer rpcServer = rpcServerMap.remove(key);
        if (rpcServer != null) {
            rpcServer.stop();
        }
    }

    public static void shutdown() {
        for (String key : rpcServerMap.keySet()) {
            RpcServerHolder.removeRpcServer(key);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RpcServerHolder::shutdown));
    }

    public static class Lock {
        private String protocol;
        private String address;

        public Lock(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Lock lock = (Lock)o;
            return Objects.equals(this.protocol, lock.protocol) && Objects.equals(this.address, lock.address);
        }

        public int hashCode() {
            return Objects.hash(this.protocol, this.address);
        }

        public String toString() {
            return "Lock{protocol='" + this.protocol + '\'' + ", address='" + this.address + '\'' + '}';
        }
    }
}

