/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.remoting.api.RemotingServer;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RemotingServerFactory {
    private static Map<String, Class<? extends RemotingServer>> remotingServerMap = new HashMap<String, Class<? extends RemotingServer>>(2);
    private static final String SPLIT = ":";

    private static String getKey(String protocol, String host, Integer port) {
        return protocol.concat(SPLIT).concat(host).concat(SPLIT).concat(String.valueOf(port));
    }

    public static RemotingServer create(String protocol) {
        Class<? extends RemotingServer> remotingServerClazz = remotingServerMap.get(protocol);
        if (Objects.isNull(remotingServerClazz)) {
            return null;
        }
        return RemotingServerFactory.create(remotingServerClazz);
    }

    public static RemotingServer create(Class<? extends RemotingServer> serverClazz) {
        try {
            RemotingServer remotingServer = (RemotingServer)ClassUtils.createObject(serverClazz, (Object[])new Object[0]);
            return remotingServer;
        }
        catch (Exception e) {
            throw new RpcException((Throwable)e);
        }
    }

    public static void addRemotingServer(String protocol, Class<? extends RemotingServer> serverClass) {
        remotingServerMap.remove(protocol);
        remotingServerMap.put(protocol, serverClass);
    }

    public static void addRemotingServer(String protocol, String serverClassStr) throws ClassNotFoundException {
        Class clazz = ClassUtils.forName((String)serverClassStr);
        if (!RemotingServer.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            throw new RpcException("\u8be5class\u4e0d\u662f RemotingServer \u7684\u5b50\u7c7b\uff0c \u6216\u8005 \u662f\u4e2a\u63a5\u53e3");
        }
        RemotingServerFactory.addRemotingServer(protocol, clazz);
    }

    static {
        try {
            RemotingServerFactory.addRemotingServer("netty", "cloud.tianai.remoting.netty.NettyServer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

