/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RemotingClientFactory {
    private static Map<String, Class<? extends RemotingClient>> remotingServerMap = new HashMap<String, Class<? extends RemotingClient>>(2);

    public static RemotingClient create(String protocol) {
        Class<? extends RemotingClient> remotingClientClazz = remotingServerMap.get(protocol);
        if (Objects.isNull(remotingClientClazz)) {
            return null;
        }
        return RemotingClientFactory.create(remotingClientClazz);
    }

    public static RemotingClient create(Class<? extends RemotingClient> clientClazz) {
        try {
            RemotingClient remotingClient = (RemotingClient)ClassUtils.createObject(clientClazz, (Object[])new Object[0]);
            return remotingClient;
        }
        catch (Exception e) {
            throw new RpcException((Throwable)e);
        }
    }

    public static void addRemotingServer(String protocol, Class<? extends RemotingClient> clientClass) {
        remotingServerMap.remove(protocol);
        remotingServerMap.put(protocol, clientClass);
    }

    public static void addRemotingServer(String protocol, String clientClassStr) throws ClassNotFoundException {
        Class clazz = ClassUtils.forName((String)clientClassStr);
        if (!RemotingClient.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            throw new RpcException("\u8be5class\u4e0d\u662f RemotingServer \u7684\u5b50\u7c7b\uff0c \u6216\u8005 \u662f\u4e2a\u63a5\u53e3");
        }
        RemotingClientFactory.addRemotingServer(protocol, clazz);
    }

    static {
        try {
            RemotingClientFactory.addRemotingServer("netty", "cloud.tianai.remoting.netty.NettyClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

