/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.registory.api.Registry;
import java.util.HashMap;
import java.util.Map;

public class RegistryFactory {
    private static Map<String, Class<? extends Registry>> registryClassMap = new HashMap<String, Class<? extends Registry>>(2);

    public static void addRegistry(String protocol, Class<? extends Registry> registryClass) {
        registryClassMap.remove(protocol);
        registryClassMap.put(protocol, registryClass);
    }

    public static void addRegistry(String protocol, String registryClassStr) throws ClassNotFoundException {
        Class clazz = ClassUtils.forName((String)registryClassStr);
        if (!Registry.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("\u6ce8\u518c\u5de5\u5382\u5fc5\u987b\u5b9e\u73b0[Registry]\u63a5\u53e3");
        }
        RegistryFactory.addRegistry(protocol, clazz);
    }

    public static Registry createRegistry(String protocol) {
        Class<? extends Registry> registryClass = registryClassMap.get(protocol);
        if (registryClass == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684registry\uff0c protocol=" + protocol);
        }
        return RegistryFactory.createRegistry(registryClass);
    }

    public static Registry createRegistry(Class<? extends Registry> registryClass) {
        try {
            return (Registry)ClassUtils.createObject(registryClass, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u521b\u5efaregistry\u5f02\u5e38" + e.getMessage());
        }
    }

    static {
        try {
            RegistryFactory.addRegistry("zookeeper", "cloud.tianai.rpc.registry.zookeeper.ZookeeperRegistry");
            RegistryFactory.addRegistry("nacos", "cloud.tianai.rpc.register.nacos.NacosRegistry");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

