/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.rpc.common.KeyValue;
import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataDecoder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CodecFactory {
    private static Map<String, KeyValue<RemotingDataEncoder, RemotingDataDecoder>> codecCache = new HashMap<String, KeyValue<RemotingDataEncoder, RemotingDataDecoder>>(2);
    private static Map<String, KeyValue<Class<? extends RemotingDataEncoder>, Class<? extends RemotingDataDecoder>>> codecClassMap = new HashMap<String, KeyValue<Class<? extends RemotingDataEncoder>, Class<? extends RemotingDataDecoder>>>(2);

    public static void registerCodec(String protocol, String encoderClassStr, String decoderClassStr) throws ClassNotFoundException {
        Class encoderClass = ClassUtils.forName((String)encoderClassStr);
        Class decoderClass = ClassUtils.forName((String)decoderClassStr);
        if (!RemotingDataEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684encoder\u5fc5\u987b\u5b9e\u73b0 [RemotingDataEncoder] \u63a5\u53e3");
        }
        if (!RemotingDataDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684decoder\u5fc5\u987b\u5b9e\u73b0 [RemotingDataDecoder] \u63a5\u53e3");
        }
        Class encoderClassCast = encoderClass;
        Class decoderClassCast = decoderClass;
        CodecFactory.registerCodec(protocol, encoderClassCast, decoderClassCast);
    }

    public static void registerCodec(String protocol, Class<? extends RemotingDataEncoder> encoderClass, Class<? extends RemotingDataDecoder> decoderClass) throws ClassNotFoundException {
        codecClassMap.remove(protocol);
        codecClassMap.put(protocol, (KeyValue<Class<? extends RemotingDataEncoder>, Class<? extends RemotingDataDecoder>>)new KeyValue(encoderClass, decoderClass));
    }

    public static KeyValue<RemotingDataEncoder, RemotingDataDecoder> getCodec(String protocol) {
        KeyValue<RemotingDataEncoder, RemotingDataDecoder> res = codecCache.get(protocol);
        if (!Objects.isNull(res)) {
            return res;
        }
        KeyValue<Class<? extends RemotingDataEncoder>, Class<? extends RemotingDataDecoder>> codecClass = codecClassMap.get(protocol);
        if (codecClass != null && codecClass.isNotEmpty()) {
            Class encoder = (Class)codecClass.getKey();
            Class decoder = (Class)codecClass.getValue();
            try {
                res = CodecFactory.getCodec(protocol, encoder, decoder);
                codecClassMap.remove(protocol);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static KeyValue<RemotingDataEncoder, RemotingDataDecoder> getCodec(String protocol, Class<? extends RemotingDataEncoder> encoderClass, Class<? extends RemotingDataDecoder> decoderClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        KeyValue res = codecCache.get(protocol);
        if (!Objects.isNull(res)) {
            return res;
        }
        RemotingDataEncoder encoder = (RemotingDataEncoder)ClassUtils.createObject(encoderClass, (Object[])new Object[0]);
        RemotingDataDecoder decoder = (RemotingDataDecoder)ClassUtils.createObject(decoderClass, (Object[])new Object[0]);
        res = new KeyValue((Object)encoder, (Object)decoder);
        codecCache.remove(protocol);
        codecCache.put(protocol, (KeyValue<RemotingDataEncoder, RemotingDataDecoder>)res);
        return res;
    }

    static {
        try {
            CodecFactory.registerCodec("hessian2", "cloud.tianai.remoting.codec.hessian2.Hessian2Encoder", "cloud.tianai.remoting.codec.hessian2.Hessian2Decoder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

